package org.findmykids.geo.data.repository.trigger.boot

import android.annotation.SuppressLint
import android.app.job.JobParameters
import android.app.job.JobService
import android.content.Intent
import android.os.Build
import androidx.annotation.RequiresApi
import org.findmykids.geo.common.di.DIScopeHolder
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.presentation.session.SessionService
import org.findmykids.geo.presentation.session.StartedJobs
import javax.inject.Inject


@SuppressLint("SpecifyJobSchedulerIdRange")
@RequiresApi(Build.VERSION_CODES.O)
internal class BootJobSchedulerService : JobService() {

    @Inject
    lateinit var mStartedJobs: StartedJobs


    override fun onStartJob(params: JobParameters): Boolean {
        Logger.d().print()
        DIScopeHolder.createSessionScope().inject(this)
        mStartedJobs.addJob(this, params)
        val intent = Intent(applicationContext, SessionService::class.java)
        intent.action = BootReceiver.ACTION_BOOT
        applicationContext.startForegroundService(intent)
        return true
    }

    override fun onStopJob(params: JobParameters): Boolean {
        Logger.d().print()
        return false
    }


    companion object {
        const val JOB_ID = 45635602
    }
}