package org.findmykids.geo.data.repository.trigger.activity

import android.app.job.JobInfo
import android.app.job.JobScheduler
import android.content.BroadcastReceiver
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.PersistableBundle
import androidx.core.content.ContextCompat
import com.google.gson.Gson
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.ActivityEvent
import org.findmykids.geo.presentation.session.SessionService
import java.util.concurrent.TimeUnit


internal abstract class BaseActivityReceiver : BroadcastReceiver() {
    protected fun send(context: Context, activityEvent: ActivityEvent) {
        val textActivityEvent = Gson().toJson(activityEvent)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val extras = PersistableBundle().apply {
                putString(EXTRA_ACTIVITY_EVENT, textActivityEvent)
            }
            val jobInfo = JobInfo
                .Builder(ActivityJobSchedulerService.JOB_ID, ComponentName(context, ActivityJobSchedulerService::class.java))
                .setOverrideDeadline(TimeUnit.SECONDS.toMillis(5))
                .setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY)
                .setExtras(extras)
                .build()
            val jobScheduler = ContextCompat.getSystemService(context, JobScheduler::class.java)
            jobScheduler?.let {
                Logger.d("job scheduled").with(this@BaseActivityReceiver).print()
                it.schedule(jobInfo)
            }
        } else {
            val actionIntent = Intent(context, SessionService::class.java)
            actionIntent.action = ACTION_ACTIVITY
            actionIntent.putExtra(EXTRA_ACTIVITY_EVENT, textActivityEvent)
            context.startService(actionIntent)
        }
    }


    companion object {
        const val ACTION_ACTIVITY = "ACTION_ACTIVITY"
        const val EXTRA_ACTIVITY_EVENT = "EXTRA_ACTIVITY_EVENT"
    }
}