package org.findmykids.geo.data.repository.trigger.activity

import com.google.android.gms.location.ActivityTransitionEvent
import com.huawei.hms.location.ActivityConversionData
import org.findmykids.geo.data.model.ActivityEvent


internal object ActivityEventFactory {
    fun createFromTransition(events: List<ActivityTransitionEvent>) = ActivityEvent(
        events.map {
            ActivityEvent.Activity(
                it.activityType,
                it.transitionType,
                it.elapsedRealTimeNanos
            )
        }
    )

    fun createFromConversion(events: List<ActivityConversionData>) = ActivityEvent(
        events.map {
            ActivityEvent.Activity(
                it.activityType - 100,
                it.conversionType,
                it.elapsedTimeFromReboot
            )
        }
    )
}