package org.findmykids.geo.data.repository.storage.yandexLocator

import com.google.gson.JsonArray
import com.google.gson.JsonObject
import io.reactivex.Single
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.data.model.Lbs
import org.findmykids.geo.data.model.LocatorLocation
import org.findmykids.geo.data.model.WifiFull
import org.findmykids.geo.data.network.YandexApi
import org.findmykids.geo.data.network.model.YandexPosition
import java.util.*
import javax.inject.Inject


internal class YandexLocatorRepositoryImpl @Inject constructor(
    private val mYandexApi: YandexApi
) : YandexLocatorRepository {

    override fun toString(): String = ""

    override fun get(wifiFullList: List<WifiFull>, lbsList: List<Lbs>, date: Date): Single<LocatorLocation> = Single
        .fromCallable {
            if (wifiFullList.isEmpty() && lbsList.isEmpty()) {
                throw GeoException.YandexEmptyData()
            }
            JsonObject().apply {
                val common = JsonObject().apply {
                    addProperty("version", "1.0")
                    addProperty("api_key", "AIHPdlUBAAAA02CcYwIAslggTBfkXmwX7gUduKURcraXa2oAAAAAAAAAAAAiqtwYUYg9D-Iq5YwAAxtIzYQAjQ==")
                }
                add("common", common)
                if (wifiFullList.isNotEmpty()) {
                    val wifiNetworks = JsonArray()
                    wifiFullList.forEach {
                        wifiNetworks.add(
                            JsonObject().apply {
                                addProperty("mac", it.bssid)
                                addProperty("signal_strength", it.level)
                            }
                        )
                    }
                    add("wifi_networks", wifiNetworks)
                }
                if (lbsList.isNotEmpty()) {
                    val gsmCells = JsonArray()
                    lbsList.forEach {
                        gsmCells.add(
                            JsonObject().apply {
                                addProperty("countrycode", it.countryCode)
                                addProperty("operatorid", it.operatorId)
                                addProperty("cellid", it.cellId)
                                addProperty("lac", it.lac)
                                if (it.level != -1) {
                                    addProperty("signal_strength", it.level)
                                }
                            }
                        )
                    }
                    add("gsm_cells", gsmCells)
                }
            }
        }
        .flatMap {
            mYandexApi
                .geoLocation(it)
                .doOnError { throwable ->
                    Single.error<YandexPosition>(GeoException.YandexLocatorConnection(throwable))
                }
        }
        .map { yandexPosition ->
            yandexPosition.error?.let {
                Single.error<LocatorLocation>(GeoException.YandexLocatorResponse(it.code, it.message))
            }
            yandexPosition.position!!.run {
                LocatorLocation(
                    latitude,
                    longitude,
                    altitude,
                    precision,
                    altitude_precision,
                    type,
                    date.time
                )
            }
        }
}