package org.findmykids.geo.data.repository.storage.authorisation

import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.Container


internal interface AuthorisationRepository {
    fun set(baseUrl: String, apiKey: CharArray, userToken: CharArray, userId: CharArray): Completable

    fun isAuthorised(): Single<Boolean>

    fun getBaseUrl(): Single<Container<String>>

    fun getUserId(): Single<Container<CharArray>>

    fun clear(): Completable
}