package org.findmykids.geo.data.repository.live.location

import android.Manifest
import androidx.annotation.RequiresPermission
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.data.model.Configuration
import org.findmykids.geo.data.model.Location


internal interface LocationSourceProvider {
    @Throws(GeoException::class)
    @RequiresPermission(anyOf = [Manifest.permission.ACCESS_COARSE_LOCATION, Manifest.permission.ACCESS_FINE_LOCATION])
    fun start(configuration: Configuration.LocationDataConfiguration)

    @Throws(GeoException::class)
    fun stop()


    interface Callback {
        fun onLocation(location: Location)
    }
}