package org.findmykids.geo.data.repository.live.location

import android.os.Build
import org.findmykids.geo.data.model.Location
import org.findmykids.geo.data.model.LocationSource


internal object LocationFactory {
    fun createLocation(location: android.location.Location, source: LocationSource): Location = when {
        Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q -> Location(
            location.latitude,
            location.longitude,
            location.provider,
            location.time,
            if (location.hasAltitude()) location.altitude else null,
            if (location.hasAccuracy()) location.accuracy else null,
            if (location.hasBearing()) location.bearing else null,
            if (location.hasElapsedRealtimeUncertaintyNanos()) location.elapsedRealtimeUncertaintyNanos else null,
            if (location.hasSpeed()) location.speed else null,
            if (location.hasSpeedAccuracy()) location.speedAccuracyMetersPerSecond else null,
            if (location.hasVerticalAccuracy()) location.verticalAccuracyMeters else null,
            if (location.hasBearingAccuracy()) location.bearingAccuracyDegrees else null,
            location.elapsedRealtimeNanos,
            source
        )
        Build.VERSION.SDK_INT >= Build.VERSION_CODES.O -> Location(
            location.latitude,
            location.longitude,
            location.provider,
            location.time,
            if (location.hasAltitude()) location.altitude else null,
            if (location.hasAccuracy()) location.accuracy else null,
            if (location.hasBearing()) location.bearing else null,
            null,
            if (location.hasSpeed()) location.speed else null,
            if (location.hasSpeedAccuracy()) location.speedAccuracyMetersPerSecond else null,
            if (location.hasVerticalAccuracy()) location.verticalAccuracyMeters else null,
            if (location.hasBearingAccuracy()) location.bearingAccuracyDegrees else null,
            location.elapsedRealtimeNanos,
            source
        )
        Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1 -> Location(
            location.latitude,
            location.longitude,
            location.provider,
            location.time,
            if (location.hasAltitude()) location.altitude else null,
            if (location.hasAccuracy()) location.accuracy else null,
            if (location.hasBearing()) location.bearing else null,
            null,
            if (location.hasSpeed()) location.speed else null,
            null,
            null,
            null,
            location.elapsedRealtimeNanos,
            source
        )
        else -> Location(
            location.latitude,
            location.longitude,
            location.provider,
            location.time,
            if (location.hasAltitude()) location.altitude else null,
            if (location.hasAccuracy()) location.accuracy else null,
            if (location.hasBearing()) location.bearing else null,
            null,
            if (location.hasSpeed()) location.speed else null,
            null,
            null,
            null,
            null,
            source
        )
    }
}