package org.findmykids.geo.data.repository.live.lbs

import android.os.Build
import android.telephony.*
import androidx.annotation.RequiresApi
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.data.model.Lbs


@RequiresApi(Build.VERSION_CODES.JELLY_BEAN_MR1)
internal object LbsListFactory {
    fun createFromCellInfoList(cellInfoList: List<CellInfo>) = cellInfoList
        .mapNotNull {
            try {
                createFromCellInfo(it)
            } catch (e: GeoException.InvalidLbsCellInfoType) {
                null
            }
        }


    @Suppress("DEPRECATION")
    private fun createFromCellInfo(cellInfo: CellInfo): Lbs = when {
        cellInfo is CellInfoGsm -> Lbs(
            cellInfo.cellIdentity.mcc,
            cellInfo.cellIdentity.mnc,
            cellInfo.cellIdentity.cid,
            cellInfo.cellIdentity.lac,
            cellInfo.cellSignalStrength.dbm
        )
        cellInfo is CellInfoCdma -> throw GeoException.InvalidLbsCellInfoType(cellInfo)
        cellInfo is CellInfoLte -> Lbs(
            cellInfo.cellIdentity.mcc,
            cellInfo.cellIdentity.mnc,
            cellInfo.cellIdentity.ci,
            cellInfo.cellIdentity.tac,
            cellInfo.cellSignalStrength.dbm
        )
        Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR2 && cellInfo is CellInfoWcdma -> Lbs(
            cellInfo.cellIdentity.mcc,
            cellInfo.cellIdentity.mnc,
            cellInfo.cellIdentity.cid,
            cellInfo.cellIdentity.lac,
            cellInfo.cellSignalStrength.dbm
        )
        Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q && cellInfo is CellInfoTdscdma -> throw GeoException.InvalidLbsCellInfoType(cellInfo)
        Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q && cellInfo is CellInfoNr -> throw GeoException.InvalidLbsCellInfoType(cellInfo)
        else -> throw GeoException.InvalidLbsCellInfoType(cellInfo)
    }
}