package org.findmykids.geo.data.repository.live.activity.google

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import com.google.android.gms.location.ActivityRecognitionResult
import org.findmykids.geo.common.di.DIScopeHolder
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.live.activity.ActivityFactory
import org.findmykids.geo.data.repository.live.activity.ActivityRepository
import javax.inject.Inject


internal class ActivityGoogleReceiver : BroadcastReceiver() {
    @Inject
    lateinit var mActivityRepository: ActivityRepository

    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        // di
        DIScopeHolder.createSessionScope().inject(this)
        ActivityRecognitionResult.extractResult(intent)?.let { results ->
            Logger.d().addArg(results).with(this@ActivityGoogleReceiver).print()
            mActivityRepository.send(ActivityFactory.create(results))
        }
    }
}