@file:Suppress("ArrayInDataClass")

package org.findmykids.geo.data.network.model

import android.os.Build
import java.nio.ByteBuffer
import java.util.concurrent.atomic.AtomicInteger


internal data class SocketData(
    val payload: ByteArray? = null,
    val headerLength: Short = HEADER_SIZE.toShort(),
    val commandId: SocketCommand = SocketCommand.SET_COORDS,
    val commandStatus: Short = 0,
    val sequenceNumber: Short = createSequenceNumber(),
    val optional1: Long = 0,
    val optional2: Long = 0,
    val optional3: Long = 0
) {
    override fun toString(): String = ""


    fun toByteArray(): ByteArray = ByteBuffer
        .allocate(HEADER_SIZE + (payload?.size ?: 0))
        .apply {
            position(0)
            putShort(headerLength)
            putShort(commandId.id)
            putShort(commandStatus)
            putShort(sequenceNumber)
            putLong(optional1)
            putLong(optional2)
            putLong(optional3)
            payload?.let {
                put(it)
            }
        }
        .array()


    companion object {
        private const val HEADER_SIZE = 32
        private val COUNTER: AtomicInteger = AtomicInteger()


        private fun createSequenceNumber(): Short =
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                COUNTER.getAndUpdate {
                    if (it == Short.MAX_VALUE.toInt()) {
                        0
                    } else {
                        it + 1
                    }
                }
            } else {
                synchronized(COUNTER) {
                    val sequenceNumber = COUNTER.getAndIncrement()
                    if (sequenceNumber == Short.MAX_VALUE.toInt()) {
                        COUNTER.set(0)
                    }
                    sequenceNumber
                }
            }.toShort()
    }
}