package org.findmykids.geo.data.network.model


enum class SocketCommand(val id: Short) {
    START(0x01), // Запрос инициализации сессии подключения
    STOP(0x02), // Закрытие соединения
    UPDATE_CONFIGURATION(0x0A), // Обновить конфигурацию
    UPDATE_SAFE_ZONE(0x0B), // Обновить безопасные зоны
    SET_COORDS(0x0C), // Отправить координаты
    LIVE_ON(0x0D), // Вкл. реалтайм гео
    LIVE_OFF(0x0E), // Выкл. реалтайм гео
    GET_GEO(0x0F), // Запрос координаты
    GET_RETRY(0x10), // Перезапрос координаты
    COORD_NOT_CHANGED(0x11), // Координата не изменилась
    COORD_EMPTY(0x12), // Координата отсутствует
    CHILD_CLOSED_CONNECTION(0x13),
    CHILD_ESTABLISHED_CONNECTION(0x14);


    companion object {
        fun getById(id: Short) = values().firstOrNull { it.id == id }
    }
}