package org.findmykids.geo.data.network

import io.reactivex.schedulers.Schedulers
import okhttp3.MediaType
import okhttp3.OkHttpClient
import okhttp3.RequestBody
import okio.Buffer
import retrofit2.Retrofit
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit


//TODO яндекс
internal class YandexClient {
    private val mApi: YandexApi by lazy {
        val okHttpClient = OkHttpClient()
            .newBuilder()
            .readTimeout(TIMEOUT, TimeUnit.SECONDS)
            .connectTimeout(TIMEOUT, TimeUnit.SECONDS)
            .addInterceptor {
                val buffer = Buffer()
                it.request().body()!!.writeTo(buffer)
                val newBody = RequestBody.create(MediaType.parse("charset=UTF-8"), "json=${buffer.readUtf8()}")
                it.proceed(it.request().newBuilder().post(newBody).build())
            }
            .build()
        Retrofit.Builder()
            .baseUrl("https://api.lbs.yandex.net")
            .client(okHttpClient)
            .addConverterFactory(GsonConverterFactory.create())
            .addCallAdapterFactory(RxJava2CallAdapterFactory.createWithScheduler(Schedulers.io()))
            .build()
            .create(YandexApi::class.java)
    }


    fun getApi() = mApi


    companion object {
        private const val TIMEOUT = 30L
    }
}