package org.findmykids.geo.data.model

import java.util.*


data class GeoLocation(
    val create: Date,
    val session: Session,
    val location: Location,
    val locationDefineSessionIndex: Long, // индекс локации по порядку их определений в пределах текущий сесии
    val locationDefineGlobalIndex: Long, // индекс локации по порядку их определений за все время
    val calculatedLocation: CalculatedLocation?,
    val gpsInfo: GpsInfo?,
    val activity: Activity?,
    val battery: Battery?,
    val wifi: Wifi?,
    val extensions: Map<String, String>
) {
    override fun toString(): String {
        return "${this::class.simpleName}(" +
                "${this::class.java.declaredFields[3].name}=$create, " +
                "${this::class.java.declaredFields[9].name}=$session, " +
                "${this::class.java.declaredFields[6].name}=$location, " +
                "${this::class.java.declaredFields[8].name}=$locationDefineSessionIndex, " +
                "${this::class.java.declaredFields[7].name}=$locationDefineGlobalIndex, " +
                "${this::class.java.declaredFields[2].name}=$calculatedLocation, " +
                "${this::class.java.declaredFields[5].name}=$gpsInfo, " +
                "${this::class.java.declaredFields[0].name}=$activity, " +
                "${this::class.java.declaredFields[1].name}=$battery, " +
                "${this::class.java.declaredFields[10].name}=$wifi, " +
                "${this::class.java.declaredFields[4].name}=$extensions)"
    }
}