package org.findmykids.geo.data.model

import androidx.annotation.IntDef
import com.google.android.gms.location.DetectedActivity
import java.util.*


data class ActivityEvent(
    val items: List<Activity>,
    val create: Date = Date()
) {
    override fun toString(): String {
        return "${this::class.simpleName}(" +
                "${this::class.java.declaredFields[1].name}=$items, " +
                "${this::class.java.declaredFields[0].name}=$create)"
    }


    data class Activity(
        @DetectedActivityType
        val activityType: Int,
        @DetectedTransitionType
        val transitionType: Int,
        val elapsedRealTimeNanos: Long
    ) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[0].name}=$activityType, " +
                    "${this::class.java.declaredFields[2].name}=$transitionType, " +
                    "${this::class.java.declaredFields[1].name}=$elapsedRealTimeNanos)"
        }
    }


    companion object {
        @IntDef(
            DetectedActivity.IN_VEHICLE,
            DetectedActivity.ON_BICYCLE,
            DetectedActivity.ON_FOOT,
            DetectedActivity.STILL,
            DetectedActivity.UNKNOWN,
            DetectedActivity.TILTING,
            DetectedActivity.WALKING,
            DetectedActivity.RUNNING
        )
        @Retention(AnnotationRetention.SOURCE)
        annotation class DetectedActivityType

        @IntDef(
            com.google.android.gms.location.ActivityTransition.ACTIVITY_TRANSITION_ENTER,
            com.google.android.gms.location.ActivityTransition.ACTIVITY_TRANSITION_EXIT
        )
        @Retention(AnnotationRetention.SOURCE)
        annotation class DetectedTransitionType
    }
}