package org.findmykids.geo.data.db.dao

import androidx.room.*
import org.findmykids.geo.common.logger.LogEntity


@Dao
internal interface LogsDao {
    @Query("SELECT * FROM LogEntity")
    fun selectAll(): List<LogEntity>

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insert(logEntity: LogEntity)

    @Delete
    fun delete(logEntity: LogEntity)

    @Query("DELETE FROM LogEntity")
    fun deleteAll()
}