package org.findmykids.geo.data.db.converter

import androidx.room.TypeConverter
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import org.findmykids.geo.data.model.CommandType


internal class SessionCommandsTypesListConverter {
    @TypeConverter
    fun to(list: String): List<CommandType> {
        return Gson().fromJson(list, object : TypeToken<List<CommandType>>() {}.type)
    }

    @TypeConverter
    fun from(list: List<CommandType>): String {
        return Gson().toJson(list, object : TypeToken<List<CommandType>>() {}.type)
    }
}