package org.findmykids.geo.data.db.converter

import androidx.room.TypeConverter
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken


internal class ExtensionsConverter {
    @TypeConverter
    fun to(list: String): Map<String, String> {
        return Gson().fromJson(list, object : TypeToken<Map<String, String>>() {}.type)
    }

    @TypeConverter
    fun from(list: Map<String, String>): String {
        return Gson().toJson(list, object : TypeToken<Map<String, String>>() {}.type)
    }
}