package org.findmykids.geo.common.utils

import android.os.Process
import java.io.BufferedReader
import java.io.File
import java.io.FileReader
import java.io.IOException


internal object ProcessUtil {
    fun getProcessName(): String {
        val cmdline = File("/proc/" + Process.myPid() + "/cmdline")
        try {
            return BufferedReader(FileReader(cmdline)).use { reader ->
                var c: Int
                val processName = StringBuilder()
                while (reader.read().also { c = it } > 0) {
                    processName.append(c.toChar())
                }
                processName.toString()
            }
        } catch (e: IOException) {
            throw RuntimeException(e)
        }
    }
}