package org.findmykids.geo.common.utils

import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.content.Context
import android.graphics.Color
import android.os.Build
import androidx.annotation.RequiresApi
import androidx.core.app.NotificationCompat
import androidx.core.content.ContextCompat.getSystemService


internal object NotificationUtil {
    private const val CHANNEL_ID = "Geo"
    private const val CHANNEL_NAME = "Geo Background Service"


    fun create(context: Context, title: String, description: String, iconResourceId: Int): Notification {
        val channelId = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            createNotificationChannel(context)
        } else {
            ""
        }
        return NotificationCompat
            .Builder(context, channelId)
            .setOngoing(true)
            .setContentTitle(title)
            .setContentText(description)
            .setSmallIcon(iconResourceId)
            .setTicker("Ticker")
            .build()
    }

    @RequiresApi(Build.VERSION_CODES.O)
    private fun createNotificationChannel(context: Context): String {
        val chan = NotificationChannel(
            CHANNEL_ID,
            CHANNEL_NAME, NotificationManager.IMPORTANCE_NONE)
        chan.lightColor = Color.BLUE
        chan.lockscreenVisibility = Notification.VISIBILITY_PRIVATE
        val service = getSystemService(context, NotificationManager::class.java)
        service?.createNotificationChannel(chan)
        return CHANNEL_ID
    }
}