package org.findmykids.geo.common.logger

import android.annotation.SuppressLint
import android.content.Context
import androidx.room.Room
import androidx.room.RoomDatabase
import io.reactivex.schedulers.Schedulers
import io.reactivex.subjects.PublishSubject
import org.findmykids.geo.BuildConfig
import org.findmykids.geo.data.db.dao.LogsDao


internal object DBLogSaver {
    private const val LOG_DB_NAME = "LogGeoDatabase"


    private val mLock = Any()
    private var mLogsDao: LogsDao? = null
    private val mSubject: PublishSubject<LogEntity> = PublishSubject.create()


    override fun toString(): String = ""


    @SuppressLint("CheckResult")
    fun init(context: Context) {
        if (mLogsDao == null) {
            mLogsDao = Room
                .databaseBuilder(context, LogDatabase::class.java,
                    LOG_DB_NAME
                )
                .setJournalMode(RoomDatabase.JournalMode.TRUNCATE)
                .fallbackToDestructiveMigration()
                .build()
                .logsDao()
            mSubject
                .observeOn(Schedulers.newThread())
                .subscribe {
                    synchronized(mLock) {
                        mLogsDao?.insert(it)
                    }
                }
        }
    }

    fun save(pid: Long, date: String, type: LogType, className: String, methodName: String, suffix: String) {
        val logEntity = LogEntity(
            pid = pid,
            date = date,
            version = BuildConfig.VERSION_NAME,
            type = type.name,
            className = className,
            methodName = methodName,
            text = suffix
        )
        mSubject.onNext(logEntity)
    }


//    fun getLogs(action: (logs: List<LogEntity>) -> Boolean) {
//        synchronized(mLock) {
//            if (action(mLogsDao?.selectAll())) {
//                mLogsDao?.deleteAll()
//            }
//        }
//    }
}