package org.findmykids.geo.common.di.session.module

import dagger.Module
import dagger.Provides
import org.findmykids.geo.common.di.session.SessionScope
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.network.SocketClient
import org.findmykids.geo.data.network.SocketClientImpl
import org.findmykids.geo.data.network.YandexApi
import org.findmykids.geo.data.network.YandexClient
import org.findmykids.geo.data.preferences.LocalPreferences


@Module
internal class NetworkModule {
    init {
        Logger.d().print()
    }


    @Provides
    @SessionScope
    fun provideSocketClient(
        localPreferences: LocalPreferences,
        appVersion: String
    ): SocketClient = SocketClientImpl(
        localPreferences,
        appVersion
    )


    @Provides
    @SessionScope
    fun provideYandexApi(): YandexApi = YandexClient()
        .getApi()
}