package org.findmykids.geo.common.di.session.module

import dagger.Module
import dagger.Provides
import org.findmykids.geo.common.di.session.SessionScope
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.live.activity.ActivityRepository
import org.findmykids.geo.data.repository.live.battery.BatteryRepository
import org.findmykids.geo.data.repository.live.gps.GpsRepository
import org.findmykids.geo.data.repository.live.lbs.LbsRepository
import org.findmykids.geo.data.repository.live.location.LocationRepository
import org.findmykids.geo.data.repository.live.remote.RemoteRepository
import org.findmykids.geo.data.repository.live.sensors.SensorsRepository
import org.findmykids.geo.data.repository.live.timeout.TimeoutRepository
import org.findmykids.geo.data.repository.live.wifi.WifiRepository
import org.findmykids.geo.data.repository.storage.authorisation.AuthorisationRepository
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepository
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepository
import org.findmykids.geo.data.repository.storage.error.ErrorRepository
import org.findmykids.geo.data.repository.storage.geo.GeoRepository
import org.findmykids.geo.data.repository.storage.request.RequestRepository
import org.findmykids.geo.data.repository.storage.yandexLocator.YandexLocatorRepository
import org.findmykids.geo.data.repository.storage.zones.ZonesRepository
import org.findmykids.geo.data.repository.trigger.activity.ActivityManager
import org.findmykids.geo.data.repository.trigger.passive.PassiveManager
import org.findmykids.geo.data.repository.trigger.station.StationManager
import org.findmykids.geo.data.repository.trigger.timer.TimerManager
import org.findmykids.geo.data.repository.trigger.zones.ZonesManager
import org.findmykids.geo.domain.live.error.ErrorInteractor
import org.findmykids.geo.domain.live.error.ErrorInteractorImpl
import org.findmykids.geo.domain.live.location.LocationInteractor
import org.findmykids.geo.domain.live.location.LocationInteractorImpl
import org.findmykids.geo.domain.live.locator.LocatorInteractor
import org.findmykids.geo.domain.live.locator.LocatorInteractorImpl
import org.findmykids.geo.domain.live.remote.RemoteInteractor
import org.findmykids.geo.domain.live.remote.RemoteInteractorImpl
import org.findmykids.geo.domain.live.timeout.TimeoutInteractor
import org.findmykids.geo.domain.live.timeout.TimeoutInteractorImpl
import org.findmykids.geo.domain.session.SessionInteractor
import org.findmykids.geo.domain.session.SessionInteractorImpl
import org.findmykids.geo.domain.subscriber.activity.ActivitySubscriberInteractor
import org.findmykids.geo.domain.subscriber.activity.ActivitySubscriberInteractorImpl
import org.findmykids.geo.domain.subscriber.passive.PassiveSubscriberInteractor
import org.findmykids.geo.domain.subscriber.passive.PassiveSubscriberInteractorImpl
import org.findmykids.geo.domain.subscriber.station.StationSubscriberInteractor
import org.findmykids.geo.domain.subscriber.station.StationSubscriberInteractorImpl
import org.findmykids.geo.domain.subscriber.timer.TimerSubscriberInteractor
import org.findmykids.geo.domain.subscriber.timer.TimerSubscriberInteractorImpl
import org.findmykids.geo.domain.subscriber.zones.ZonesSubscriberInteractor
import org.findmykids.geo.domain.subscriber.zones.ZonesSubscriberInteractorImpl
import javax.inject.Named


@Module(includes = [DataStorageModule::class])
internal class DomainModule {
    init {
        Logger.d().print()
    }


    @Provides
    @SessionScope
    fun provideActivitySubscriberInteractor(
        activityManager: ActivityManager,
        configurationRepository: ConfigurationRepository
    ): ActivitySubscriberInteractor = ActivitySubscriberInteractorImpl(
        activityManager,
        configurationRepository
    )

    @Provides
    @SessionScope
    fun providePassiveSubscriberInteractor(
        @Named("LocationManager") passiveLocationManagerManager: PassiveManager,
        @Named("GoogleFused") passiveGoogleFusedManager: PassiveManager,
        @Named("HuaweiFused") passiveHuaweiFusedManager: PassiveManager,
        configurationRepository: ConfigurationRepository
    ): PassiveSubscriberInteractor = PassiveSubscriberInteractorImpl(
        passiveLocationManagerManager,
        passiveGoogleFusedManager,
        passiveHuaweiFusedManager,
        configurationRepository
    )

    @Provides
    @SessionScope
    fun provideTimerSubscriberInteractor(
        @Named("Alarm") timerAlarmManager: TimerManager,
        @Named("Work") timerWorkManager: TimerManager,
        configurationRepository: ConfigurationRepository
    ): TimerSubscriberInteractor = TimerSubscriberInteractorImpl(
        timerAlarmManager,
        timerWorkManager,
        configurationRepository
    )

    @Provides
    @SessionScope
    fun provideStationSubscriberInteractor(
        stationManager: StationManager,
        configurationRepository: ConfigurationRepository
    ): StationSubscriberInteractor = StationSubscriberInteractorImpl(
        stationManager,
        configurationRepository
    )

    @Provides
    @SessionScope
    fun provideZonesSubscriberInteractor(
        zonesManager: ZonesManager,
        zoneRepository: ZonesRepository
    ): ZonesSubscriberInteractor = ZonesSubscriberInteractorImpl(
        zonesManager,
        zoneRepository
    )

    @Provides
    @SessionScope
    fun provideLocationInteractor(
        geoRepository: GeoRepository,
        currentSessionRepository: CurrentSessionRepository,
        configurationRepository: ConfigurationRepository,
        gpsRepository: GpsRepository,
        batteryRepository: BatteryRepository,
        activityRepository: ActivityRepository,
        locationRepository: LocationRepository,
        wifiRepository: WifiRepository
    ): LocationInteractor = LocationInteractorImpl(
        geoRepository,
        currentSessionRepository,
        configurationRepository,
        activityRepository,
        batteryRepository,
        gpsRepository,
        locationRepository,
        wifiRepository
    )

    @Provides
    @SessionScope
    fun provideLocatorGeoInteractor(
        geoRepository: GeoRepository,
        configurationRepository: ConfigurationRepository,
        currentSessionRepository: CurrentSessionRepository,
        yandexLocatorRepository: YandexLocatorRepository,
        batteryRepository: BatteryRepository,
        lbsRepository: LbsRepository,
        wifiRepository: WifiRepository
    ): LocatorInteractor = LocatorInteractorImpl(
        geoRepository,
        configurationRepository,
        currentSessionRepository,
        yandexLocatorRepository,
        batteryRepository,
        lbsRepository,
        wifiRepository
    )

    @Provides
    @SessionScope
    fun provideRemoteInteractor(
        remoteRepository: RemoteRepository,
        geoRepository: GeoRepository,
        errorRepository: ErrorRepository,
        timeoutRepository: TimeoutRepository,
        authorisationRepository: AuthorisationRepository,
        zoneRepository: ZonesRepository,
        configurationRepository: ConfigurationRepository,
        currentSessionRepository: CurrentSessionRepository,
        requestRepository: RequestRepository,
        locationRepository: LocationRepository,
        gpsRepository: GpsRepository,
        lbsRepository: LbsRepository,
        batteryRepository: BatteryRepository,
        activityRepository: ActivityRepository,
        wifiRepository: WifiRepository,
        sensorsRepository: SensorsRepository
    ): RemoteInteractor = RemoteInteractorImpl(
        remoteRepository,
        geoRepository,
        errorRepository,
        timeoutRepository,
        authorisationRepository,
        zoneRepository,
        configurationRepository,
        currentSessionRepository,
        requestRepository,
        locationRepository,
        batteryRepository,
        activityRepository,
        gpsRepository,
        sensorsRepository,
        lbsRepository,
        wifiRepository
    )

    @Provides
    @SessionScope
    fun provideTimeoutInteractor(
        timeoutRepository: TimeoutRepository,
        activityRepository: ActivityRepository,
        batteryRepository: BatteryRepository,
        configurationRepository: ConfigurationRepository,
        currentSessionRepository: CurrentSessionRepository,
        errorRepository: ErrorRepository,
        locationRepository: LocationRepository
    ): TimeoutInteractor = TimeoutInteractorImpl(
        configurationRepository,
        currentSessionRepository,
        errorRepository,
        timeoutRepository,
        activityRepository,
        batteryRepository,
        locationRepository
    )

    @Provides
    @SessionScope
    fun provideErrorInteractor(
        timeoutRepository: TimeoutRepository,
        activityRepository: ActivityRepository,
        batteryRepository: BatteryRepository,
        configurationRepository: ConfigurationRepository,
        currentSessionRepository: CurrentSessionRepository,
        gpsRepository: GpsRepository,
        errorRepository: ErrorRepository,
        lbsRepository: LbsRepository,
        locationRepository: LocationRepository,
//        remoteRepository: RemoteRepository,
        sensorsRepository: SensorsRepository,
        wifiRepository: WifiRepository
    ): ErrorInteractor = ErrorInteractorImpl(
        configurationRepository,
        errorRepository,
        currentSessionRepository,
        activityRepository,
        batteryRepository,
        gpsRepository,
        lbsRepository,
        locationRepository,
//        remoteRepository,
        sensorsRepository,
        timeoutRepository,
        wifiRepository
    )

    @Provides
    @SessionScope
    fun provideSessionInteractor(
        currentSessionRepository: CurrentSessionRepository
    ): SessionInteractor = SessionInteractorImpl(
        currentSessionRepository
    )
}