package org.findmykids.geo.common.di.session.module

import android.content.Context
import com.huawei.hms.location.ActivityIdentification
import dagger.Module
import dagger.Provides
import org.findmykids.geo.common.di.session.SessionScope
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.common.utils.ManufactureUtil
import org.findmykids.geo.data.network.SocketClient
import org.findmykids.geo.data.preferences.LocalPreferences
import org.findmykids.geo.data.repository.live.activity.ActivityRepository
import org.findmykids.geo.data.repository.live.activity.google.ActivityRepositoryGoogleImpl
import org.findmykids.geo.data.repository.live.activity.huawei.ActivityRepositoryHuaweiImpl
import org.findmykids.geo.data.repository.live.battery.BatteryRepository
import org.findmykids.geo.data.repository.live.battery.BatteryRepositoryImpl
import org.findmykids.geo.data.repository.live.gps.GpsRepository
import org.findmykids.geo.data.repository.live.gps.GpsRepositoryImpl
import org.findmykids.geo.data.repository.live.lbs.LbsRepository
import org.findmykids.geo.data.repository.live.lbs.LbsRepositoryImpl
import org.findmykids.geo.data.repository.live.location.LocationRepository
import org.findmykids.geo.data.repository.live.location.LocationRepositoryImpl
import org.findmykids.geo.data.repository.live.remote.RemoteRepository
import org.findmykids.geo.data.repository.live.remote.RemoteRepositoryImpl
import org.findmykids.geo.data.repository.live.sensors.SensorsRepository
import org.findmykids.geo.data.repository.live.sensors.SensorsRepositoryImpl
import org.findmykids.geo.data.repository.live.timeout.TimeoutRepository
import org.findmykids.geo.data.repository.live.timeout.TimeoutRepositoryImpl
import org.findmykids.geo.data.repository.live.wifi.WifiRepository
import org.findmykids.geo.data.repository.live.wifi.WifiRepositoryImpl
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepository


@Module
internal class DataLiveModule {
    init {
        Logger.d().print()
    }


    @Provides
    @SessionScope
    fun provideActivityRepository(
        context: Context
    ): ActivityRepository = if (ManufactureUtil.isHuawei() && ManufactureUtil.isEmuiVersion9_1orAfter()) {
        try {
            ActivityIdentification.getService(context)!!
            ActivityRepositoryHuaweiImpl(context)
        } catch (e: Exception) {
            ActivityRepositoryGoogleImpl(context)
        }
    } else {
        ActivityRepositoryGoogleImpl(context)
    }

    @Provides
    @SessionScope
    fun provideBatteryRepository(
        context: Context
    ): BatteryRepository = BatteryRepositoryImpl(
        context
    )

    @Provides
    @SessionScope
    fun provideGpsRepository(
        context: Context
    ): GpsRepository = GpsRepositoryImpl(
        context
    )

    @Provides
    @SessionScope
    fun provideLbsRepository(
        context: Context,
        localPreferences: LocalPreferences
    ): LbsRepository = LbsRepositoryImpl(
        context,
        localPreferences
    )

    @Provides
    @SessionScope
    fun provideLocationRepository(
        context: Context,
        localPreferences: LocalPreferences
    ): LocationRepository = LocationRepositoryImpl(
        context,
        localPreferences
    )

    @Provides
    @SessionScope
    fun provideRemoteRepository(
        socketClient: SocketClient,
        context: Context,
        currentSessionRepository: CurrentSessionRepository
    ): RemoteRepository = RemoteRepositoryImpl(
        socketClient,
        context,
        currentSessionRepository
    )

    @Provides
    @SessionScope
    fun provideSensorsRepository(
        context: Context
    ): SensorsRepository = SensorsRepositoryImpl(
        context
    )

    @Provides
    @SessionScope
    fun provideTimeoutRepository(): TimeoutRepository = TimeoutRepositoryImpl()

    @Provides
    @SessionScope
    fun provideWifiRepository(
        context: Context,
        localPreferences: LocalPreferences
    ): WifiRepository = WifiRepositoryImpl(
        context,
        localPreferences
    )
}