package org.findmykids.geo.common.di.root.module

import dagger.Module
import dagger.Provides
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.storage.log.LogRepository
import org.findmykids.geo.data.repository.storage.log.LogRepositoryImpl
import org.findmykids.geo.domain.log.LogInteractor
import org.findmykids.geo.domain.log.LogInteractorImpl
import javax.inject.Singleton


@Module
internal class LogModule {
    init {
        Logger.d().print()
    }


    @Provides
    @Singleton
    fun provideLogRepository(): LogRepository = LogRepositoryImpl()

    @Provides
    @Singleton
    fun provideLogInteractor(
        logRepository: LogRepository
    ): LogInteractor = LogInteractorImpl(
        logRepository
    )
}