package org.findmykids.geo.common.di.root

import android.content.Context
import dagger.Component
import org.findmykids.geo.common.di.root.module.ContextModule
import org.findmykids.geo.common.di.platform.PlatformComponent
import org.findmykids.geo.common.di.root.module.AuthorityModule
import org.findmykids.geo.common.di.root.module.LogModule
import org.findmykids.geo.presentation.manage.AuthorityCheckProvider
import javax.inject.Singleton


@Singleton
@Component(
    modules = [ContextModule::class, LogModule::class, AuthorityModule::class]
)
internal interface RootComponent {
    fun context(): Context

    fun inject(authorityCheckProvider: AuthorityCheckProvider)

    fun platformComponentBuilder(): PlatformComponent.Builder
}