package org.findmykids.geo.api.extensions

import androidx.annotation.MainThread
import org.findmykids.geo.domain.model.Command


/**
 * Расширение работы сессии
 * Нужно чтобы чтото сделать в определенные мементы работы сесиии
 * Работает в процессе гео платформы
 */
interface SessionExtensions {
    /**
     * Сессия началась
     */
    @MainThread
    fun onSessionBegin()

    /**
     * Добавлена новая команда
     */
    @MainThread
    fun onNewCommand(command: Command)

    /**
     * Сессия заканчивается
     */
    @MainThread
    fun onSessionEnd()
}