package org.findmykids.geo.api.extensions

import com.google.protobuf.MessageLite
import org.findmykids.geo.data.model.SendGeoLocation


/**
 * Расширение работы с геолокацией
 * Нужно чтобы добавить дополнительную информацию и правильно передать ее на бэк
 * Работает в процессе гео платформы
 */
interface GeoExtensions {
    /**
     * Сработает когда буден создана геолокация, которую надо отправить на бэк
     */
    fun extendGeo(sendGeoLocation: SendGeoLocation)

    /**
     * Сработает в момент отправки геолокации на бэк
     */
    fun mapExtensions(sendGeoLocation: SendGeoLocation): List<MessageLite>
}