package org.findmykids.geo._todo

import org.findmykids.geo.data.model.*
import java.util.*


//TODO яндекс
sealed class Geo(
    val type: Int,
    val session: Session,
    val create: Date,
    val extensions: MutableMap<String, String>
) {

    override fun toString(): String = ""


    fun getLocation(): Location? = when (this) {
        is LbsLocatorLocationGeo -> Location(
            locatorLocation.latitude,
            locatorLocation.longitude,
            LocatorLocation.PROVIDER,
            locatorLocation.time,
            locatorLocation.altitude,
            locatorLocation.accuracy.toFloat(),
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            LocationSource.LOCATION_MANAGER
        )
        is LbsLocatorErrorGeo -> null
        is WifiLocatorLocationGeo -> Location(
            locatorLocation.latitude,
            locatorLocation.longitude,
            LocatorLocation.PROVIDER,
            locatorLocation.time,
            locatorLocation.altitude,
            locatorLocation.accuracy.toFloat(),
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            LocationSource.LOCATION_MANAGER
        )
        is WifiLocatorErrorGeo -> null
    }

    fun getError(): String? = when (this) {
        is LbsLocatorLocationGeo -> null
        is LbsLocatorErrorGeo -> locatorError
        is WifiLocatorLocationGeo -> null
        is WifiLocatorErrorGeo -> locatorError
    }

    //region Lbs
    class LbsLocatorLocationGeo(
        val lbsList: List<Lbs>,
        val wifiFullList: List<WifiFull>,
        val locatorLocation: LocatorLocation,
        session: Session,
        create: Date = Date(),
        extensions: MutableMap<String, String> = mutableMapOf()
    ) : Geo(Type.LBS_LOCATOR_LOCATION.value, session, create, extensions) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[2].name}=$session, " +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.superclass!!.declaredFields[1].name}=$extensions, " +
                    "${this::class.java.declaredFields[0].name}=$lbsList, " +
                    "${this::class.java.declaredFields[2].name}=$wifiFullList, " +
                    "${this::class.java.declaredFields[1].name}=$locatorLocation)"
        }
    }

    class LbsLocatorErrorGeo(
        val lbsList: List<Lbs>,
        val wifiFullList: List<WifiFull>,
        val locatorError: String,
        session: Session,
        create: Date = Date(),
        extensions: MutableMap<String, String> = mutableMapOf()
    ) : Geo(Type.LBS_LOCATOR_ERROR.value, session, create, extensions) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[2].name}=$session, " +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.superclass!!.declaredFields[1].name}=$extensions, " +
                    "${this::class.java.declaredFields[0].name}=$lbsList, " +
                    "${this::class.java.declaredFields[2].name}=$wifiFullList, " +
                    "${this::class.java.declaredFields[1].name}=$locatorError)"
        }
    }
    // endregion


    //region WifiFull
    class WifiLocatorLocationGeo(
        val wifiFullList: List<WifiFull>,
        val lbsList: List<Lbs>,
        val locatorLocation: LocatorLocation,
        session: Session,
        create: Date = Date(),
        extensions: MutableMap<String, String> = mutableMapOf()
    ) : Geo(Type.WIFI_LOCATOR_LOCATION.value, session, create, extensions) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[2].name}=$session, " +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.superclass!!.declaredFields[1].name}=$extensions, " +
                    "${this::class.java.declaredFields[2].name}=$wifiFullList, " +
                    "${this::class.java.declaredFields[0].name}=$lbsList, " +
                    "${this::class.java.declaredFields[1].name}=$locatorLocation)"
        }
    }

    class WifiLocatorErrorGeo(
        val wifiFullList: List<WifiFull>,
        val lbsList: List<Lbs>,
        val locatorError: String,
        session: Session,
        create: Date = Date(),
        extensions: MutableMap<String, String> = mutableMapOf()
    ) : Geo(Type.WIFI_LOCATOR_ERROR.value, session, create, extensions) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[2].name}=$session, " +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.superclass!!.declaredFields[1].name}=$extensions, " +
                    "${this::class.java.declaredFields[2].name}=$wifiFullList, " +
                    "${this::class.java.declaredFields[0].name}=$lbsList, " +
                    "${this::class.java.declaredFields[1].name}=$locatorError)"
        }
    }
    // endregion


    enum class Type(val value: Int) {
        LBS_LOCATOR_LOCATION(9),
        LBS_LOCATOR_ERROR(10),
        WIFI_LOCATOR_LOCATION(12),
        WIFI_LOCATOR_ERROR(13)
    }
}