/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.utils;

import aQute.lib.osgi.Jar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class JarUtils {
    private static final String JAR_SNAPSHOT_POSTFIX = "-SNAPSHOT";
    private static final String OSGI_SNAPSHOT_POSTFIX = ".SNAPSHOT";

    public static void adjustSnapshotOutputVersion(File inputFile, File outputFile, String version) {
        Jar jar = null;
        try {
            jar = new Jar(inputFile);
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Bundle-Version", version);
            jar.write(outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot open jar " + outputFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot open jar " + outputFile);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    public static String replaceSnapshotWithTimestamp(String version) {
        String tweakedVersion = version;
        if (version.contains(JAR_SNAPSHOT_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(JAR_SNAPSHOT_POSTFIX, "-" + JarUtils.getTimeStamp());
        } else if (version.contains(OSGI_SNAPSHOT_POSTFIX)) {
            tweakedVersion = tweakedVersion.replace(OSGI_SNAPSHOT_POSTFIX, "." + JarUtils.getTimeStamp());
        }
        return tweakedVersion;
    }

    private static String getTimeStamp() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSignature(File jar) {
        File unsignedJar = new File(jar.getParent(), jar.getName() + ".tmp");
        try {
            if (unsignedJar.exists()) {
                FileUtils.deleteQuietly((File)unsignedJar);
                unsignedJar = new File(jar.getParent(), jar.getName() + ".tmp");
            }
            if (!unsignedJar.createNewFile()) {
                throw new RuntimeException("Cannot create file " + unsignedJar);
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(unsignedJar));
            try {
                ZipFile zip = new ZipFile(jar);
                Enumeration<? extends ZipEntry> list = zip.entries();
                while (list.hasMoreElements()) {
                    ZipEntry entry = list.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || name.endsWith(".RSA") || name.endsWith(".DSA") || name.endsWith(".SF")) continue;
                    InputStream zipInputStream = zip.getInputStream(entry);
                    zipOutputStream.putNextEntry(entry);
                    try {
                        IOUtils.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream);
                    }
                    finally {
                        zipInputStream.close();
                    }
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                FileUtils.copyFile((File)unsignedJar, (File)jar);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)unsignedJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsSignature(File jarToUnsign) {
        try {
            ZipFile zip = new ZipFile(jarToUnsign);
            try {
                Enumeration<? extends ZipEntry> list = zip.entries();
                while (list.hasMoreElements()) {
                    ZipEntry entry = list.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.endsWith(".RSA") && !name.endsWith(".DSA") && !name.endsWith(".SF")) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                zip.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

