/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.resolver;

import java.io.File;

public class Artifact {
    private final String groupId;
    private final String artifactId;
    private final String baseVersion;
    private final String extension;
    private final String classifier;
    private final boolean snapshot;
    private final String version;
    private final File file;

    public Artifact(String groupId, String artifactId, String baseVersion, String extension, String classifier, boolean snapshot, String version, File file) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.baseVersion = baseVersion;
        this.extension = extension;
        this.classifier = classifier;
        this.snapshot = snapshot;
        this.version = version;
        this.file = file;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String getVersion() {
        return this.version;
    }

    public File getFile() {
        return this.file;
    }

    public String getShortId() {
        return String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getBaseVersion());
    }

    public String getExtendedId() {
        return String.format("%s:%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getExtension(), this.getBaseVersion());
    }

    public String getLongId() {
        return String.format("%s:%s:%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getExtension(), this.getClassifier(), this.getBaseVersion());
    }

    public String toString() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.groupId + "." + this.artifactId + "-" + this.version + "." + this.extension;
    }
}

