/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.reficio.p2.P2Artifact;
import org.reficio.p2.P2Helper;
import org.reficio.p2.P2Validator;
import org.reficio.p2.bundler.ArtifactBundler;
import org.reficio.p2.bundler.ArtifactBundlerInstructions;
import org.reficio.p2.bundler.ArtifactBundlerRequest;
import org.reficio.p2.bundler.impl.AquteBundler;
import org.reficio.p2.logger.Logger;
import org.reficio.p2.publisher.BundlePublisher;
import org.reficio.p2.publisher.CategoryPublisher;
import org.reficio.p2.resolver.ArtifactResolutionRequest;
import org.reficio.p2.resolver.ArtifactResolutionResult;
import org.reficio.p2.resolver.ArtifactResolver;
import org.reficio.p2.resolver.ResolvedArtifact;
import org.reficio.p2.resolver.impl.AetherResolver;

public class P2Mojo
extends AbstractMojo
implements Contextualizable {
    private static final String BUNDLES_TOP_FOLDER = "/source";
    private static final String BUNDLES_DESTINATION_FOLDER = "/source/plugins";
    private static final String DEFAULT_CATEGORY_FILE = "category.xml";
    private static final String DEFAULT_CATEGORY_CLASSPATH_LOCATION = "/";
    private MavenProject project;
    private MavenSession session;
    private BuildPluginManager pluginManager;
    private String buildDirectory;
    private String destinationDirectory;
    private EquinoxServiceFactory p2;
    private P2ApplicationLauncher launcher;
    private String categoryFileURL;
    private boolean pedantic;
    private boolean compressSite;
    private int forkedProcessTimeoutInSeconds;
    private String additionalArgs;
    private PlexusContainer container;
    private Object repoSystem;
    private Object repoSession;
    private List<Object> projectRepos;
    private List<P2Artifact> artifacts;
    private Log log = this.getLog();
    private File bundlesDestinationFolder;

    public void execute() {
        try {
            this.initializeEnvironment();
            this.initializeRepositorySystem();
            this.processArtifacts();
            this.executeP2PublisherPlugin();
            this.executeCategoryPublisher();
            this.cleanupEnvironment();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeEnvironment() throws IOException {
        Logger.initialize(this.log);
        this.bundlesDestinationFolder = new File(this.buildDirectory, BUNDLES_DESTINATION_FOLDER);
        FileUtils.deleteDirectory((File)new File(this.buildDirectory, BUNDLES_TOP_FOLDER));
        this.bundlesDestinationFolder.mkdirs();
    }

    private void initializeRepositorySystem() {
        if (this.repoSystem == null) {
            this.repoSystem = this.lookup("org.eclipse.aether.RepositorySystem");
        }
        if (this.repoSystem == null) {
            this.repoSystem = this.lookup("org.sonatype.aether.RepositorySystem");
        }
        Preconditions.checkNotNull((Object)this.repoSystem, (Object)"Could not initialize RepositorySystem");
    }

    private Object lookup(String role) {
        try {
            return this.container.lookup(role);
        }
        catch (ComponentLookupException componentLookupException) {
            return null;
        }
    }

    private void processArtifacts() {
        Multimap<P2Artifact, ResolvedArtifact> resolvedArtifacts = this.resolveArtifacts();
        for (P2Artifact p2Artifact : this.artifacts) {
            for (ResolvedArtifact resolvedArtifact : resolvedArtifacts.get((Object)p2Artifact)) {
                this.bundleArtifact(p2Artifact, resolvedArtifact);
            }
        }
    }

    private Multimap<P2Artifact, ResolvedArtifact> resolveArtifacts() {
        ArrayListMultimap resolvedArtifacts = ArrayListMultimap.create();
        for (P2Artifact p2Artifact : this.artifacts) {
            this.logResolving(p2Artifact);
            ArtifactResolutionResult resolutionResult = this.resolveArtifact(p2Artifact);
            resolvedArtifacts.putAll((Object)p2Artifact, resolutionResult.getResolvedArtifacts());
        }
        return resolvedArtifacts;
    }

    private void logResolving(P2Artifact p2) {
        this.log.info((CharSequence)String.format("Resolving artifact=[%s] transitive=[%s] source=[%s]", p2.getId(), p2.shouldIncludeTransitive(), p2.shouldIncludeSources()));
    }

    private ArtifactResolutionResult resolveArtifact(P2Artifact p2Artifact) {
        ArtifactResolutionRequest resolutionRequest = ArtifactResolutionRequest.builder().rootArtifactId(p2Artifact.getId()).resolveSource(p2Artifact.shouldIncludeSources()).resolveTransitive(p2Artifact.shouldIncludeTransitive()).excludes(p2Artifact.getExcludes()).build();
        ArtifactResolutionResult resolutionResult = this.getArtifactResolver().resolve(resolutionRequest);
        this.logResolved(resolutionRequest, resolutionResult);
        return resolutionResult;
    }

    private ArtifactResolver getArtifactResolver() {
        return new AetherResolver(this.repoSystem, this.repoSession, this.projectRepos);
    }

    private void logResolved(ArtifactResolutionRequest resolutionRequest, ArtifactResolutionResult resolutionResult) {
        for (ResolvedArtifact resolvedArtifact : resolutionResult.getResolvedArtifacts()) {
            this.log.info((CharSequence)("\t [JAR] " + resolvedArtifact.getArtifact()));
            if (resolvedArtifact.getSourceArtifact() != null) {
                this.log.info((CharSequence)("\t [SRC] " + resolvedArtifact.getSourceArtifact().toString()));
                continue;
            }
            if (!resolutionRequest.isResolveSource()) continue;
            this.log.warn((CharSequence)("\t [SRC] Failed to resolve source for artifact " + resolvedArtifact.getArtifact().toString()));
        }
    }

    private void bundleArtifact(P2Artifact p2Artifact, ResolvedArtifact resolvedArtifact) {
        P2Validator.validateBundleRequest(p2Artifact, resolvedArtifact);
        ArtifactBundler bundler = this.getArtifactBundler();
        ArtifactBundlerInstructions bundlerInstructions = P2Helper.createBundlerInstructions(p2Artifact, resolvedArtifact);
        ArtifactBundlerRequest bundlerRequest = P2Helper.createBundlerRequest(p2Artifact, resolvedArtifact, this.bundlesDestinationFolder);
        bundler.execute(bundlerRequest, bundlerInstructions);
    }

    private ArtifactBundler getArtifactBundler() {
        return new AquteBundler(this.pedantic);
    }

    private void executeP2PublisherPlugin() throws IOException, MojoExecutionException {
        this.prepareDestinationDirectory();
        BundlePublisher publisher = BundlePublisher.builder().mavenProject(this.project).mavenSession(this.session).buildPluginManager(this.pluginManager).compressSite(this.compressSite).additionalArgs(this.additionalArgs).build();
        publisher.execute();
    }

    private void prepareDestinationDirectory() throws IOException {
        FileUtils.deleteDirectory((File)new File(this.destinationDirectory));
    }

    private void executeCategoryPublisher() throws AbstractMojoExecutionException, IOException {
        this.prepareCategoryLocationFile();
        CategoryPublisher publisher = CategoryPublisher.builder().p2ApplicationLauncher(this.launcher).additionalArgs(this.additionalArgs).forkedProcessTimeoutInSeconds(this.forkedProcessTimeoutInSeconds).categoryFileLocation(this.categoryFileURL).metadataRepositoryLocation(this.destinationDirectory).build();
        publisher.execute();
    }

    private void prepareCategoryLocationFile() throws IOException {
        if (StringUtils.isBlank((String)this.categoryFileURL)) {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/category.xml");
            File destinationFolder = new File(this.destinationDirectory);
            destinationFolder.mkdirs();
            File categoryDefinitionFile = new File(destinationFolder, DEFAULT_CATEGORY_FILE);
            FileWriter writer = new FileWriter(categoryDefinitionFile);
            IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
            IOUtils.closeQuietly((Writer)writer);
            this.categoryFileURL = categoryDefinitionFile.getAbsolutePath();
        }
    }

    private void cleanupEnvironment() throws IOException {
        File workFolder = new File(this.buildDirectory, BUNDLES_TOP_FOLDER);
        try {
            FileUtils.deleteDirectory((File)workFolder);
        }
        catch (IOException ex) {
            this.log.warn((CharSequence)("Cannot cleanup the work folder " + workFolder.getAbsolutePath()));
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

