/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.graphical.GraphicalUtility;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapBuilderImpl;
import org.refcodes.graphical.RgbPixmapImageBuilder;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontAccessor;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontFamilyAccessor;
import org.refcodes.textual.FontNameAccessor;
import org.refcodes.textual.FontSizeAccessor;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.FontStyleAccessor;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.Text;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.TextLineBuilder;

public class AsciiArtBuilder
extends AbstractText<AsciiArtBuilder>
implements Text<AsciiArtBuilder>,
FontAccessor.FontProperty,
FontAccessor.FontBuilder<AsciiArtBuilder>,
FontFamilyAccessor.FontFamilyProperty,
FontFamilyAccessor.FontFamilyBuilder<AsciiArtBuilder>,
FontStyleAccessor.FontStyleProperty,
FontStyleAccessor.FontStyleBuilder<AsciiArtBuilder>,
FontSizeAccessor.FontSizeProperty,
FontSizeAccessor.FontSizeBuilder<AsciiArtBuilder>,
FontNameAccessor.FontNameProperty,
FontNameAccessor.FontNameBuilder<AsciiArtBuilder>,
ColumnWidthAccessor.ColumnWidthBuilder<AsciiArtBuilder>,
ColumnWidthAccessor.ColumnWidthProperty {
    private Font _font = new Font(FontFamily.SANS_SERIF, FontStyle.PLAIN, 16);
    private RgbPixmap _pixmap = null;
    private AsciiArtMode _asciiArtMode = AsciiArtMode.NORMAL;
    private PixmapRatioMode _pixmapRatioMode = PixmapRatioMode.NONE;
    private AsciiColorPalette _asciiColorPalette = AsciiColorPalette.HALFTONE_GRAY;
    private char[] _asciiColors = null;
    private int _columnWidth = -1;

    public PixmapRatioMode getPixmapRatioMode() {
        return this._pixmapRatioMode;
    }

    public void setPixmapRatioMode(PixmapRatioMode pixmapRatioMode) {
        this._pixmapRatioMode = pixmapRatioMode;
    }

    public RgbPixmap getRgbPixmap() {
        return this._pixmap;
    }

    public AsciiArtBuilder withColumnWidth(int n) {
        this.setColumnWidth(n);
        return this;
    }

    public void setColumnWidth(int n) {
        this._columnWidth = n;
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    @Override
    public void setFont(Font font) {
        this._font = font;
    }

    @Override
    public AsciiArtBuilder withFont(Font font) {
        this.setFont(font);
        return this;
    }

    public AsciiArtMode getAsciiArtMode() {
        return this._asciiArtMode;
    }

    public void setAsciiArtMode(AsciiArtMode asciiArtMode) {
        this._asciiArtMode = asciiArtMode;
    }

    public char[] getAsciiColors() {
        return this._asciiColors != null ? this._asciiColors : (char[])(this._asciiColorPalette != null ? this._asciiColorPalette.getPalette() : null);
    }

    public void setAsciiColors(char ... cArray) {
        this._asciiColors = cArray;
        this._asciiColorPalette = null;
    }

    public AsciiColorPalette getAsciiColorPalette() {
        return this._asciiColorPalette;
    }

    public void setAsciiColorPalette(AsciiColorPalette asciiColorPalette) {
        this._asciiColorPalette = asciiColorPalette;
        this._asciiColors = null;
    }

    @Override
    public FontFamily getFontFamily() {
        return this._font != null ? this._font.getFamily() : null;
    }

    @Override
    public void setFontFamily(FontFamily fontFamily) {
        if (this._font == null) {
            this._font = new Font();
        }
        this._font.setFamily(fontFamily);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontFamily(FontFamily fontFamily) {
        this.setFontFamily(fontFamily);
        return this;
    }

    @Override
    public FontStyle getFontStyle() {
        return this._font != null ? this._font.getStyle() : null;
    }

    @Override
    public void setFontStyle(FontStyle fontStyle) {
        if (this._font == null) {
            this._font = new Font();
        }
        this._font.setStyle(fontStyle);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontStyle(FontStyle fontStyle) {
        this.setFontStyle(fontStyle);
        return this;
    }

    @Override
    public int getFontSize() {
        return this._font != null ? Integer.valueOf(this._font.getSize()) : null;
    }

    @Override
    public void setFontSize(int n) {
        if (this._font == null) {
            this._font = new Font();
        }
        this._font.setSize(n);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontSize(int n) {
        this.setFontSize(n);
        return this;
    }

    @Override
    public String getFontName() {
        return this._font != null ? this._font.getName() : null;
    }

    @Override
    public void setFontName(String string) {
        if (this._font == null) {
            this._font = new Font();
        }
        this._font.setName(string);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontName(String string) {
        this.setFontName(string);
        return this;
    }

    public void setRgbPixmap(RgbPixmap rgbPixmap) {
        this._pixmap = rgbPixmap;
    }

    @Override
    public String[] toStrings() {
        if (this._pixmap != null) {
            return AsciiArtBuilder.asAsciiArt(this._pixmap, this.getColumnWidth(), this.getAsciiArtMode(), this.getPixmapRatioMode(), this.getAsciiColors());
        }
        if (this.getText() != null) {
            return AsciiArtBuilder.asAsciiArt(this._columnWidth, this._font, this._asciiArtMode, this.getAsciiColors(), this.getText());
        }
        throw new IllegalStateException("Cannot invoke the ASCII-Art generation as there is neither a text nor a pixmap being set.");
    }

    @Override
    public String[] toStrings(String ... stringArray) {
        return AsciiArtBuilder.asAsciiArt(this._columnWidth, this._font, this._asciiArtMode, this.getAsciiColors(), stringArray);
    }

    public String toString(RgbPixmap rgbPixmap) {
        Object object = "";
        String[] stringArray = this.toStrings(rgbPixmap);
        for (int i = 0; i < stringArray.length; ++i) {
            object = (String)object + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            object = (String)object + Terminal.getLineBreak();
        }
        return object;
    }

    public String[] toStrings(RgbPixmap rgbPixmap) {
        return AsciiArtBuilder.asAsciiArt(rgbPixmap, this.getColumnWidth(), this.getAsciiArtMode(), this.getPixmapRatioMode(), this.getAsciiColors());
    }

    public AsciiArtBuilder withAsciiArtMode(AsciiArtMode asciiArtMode) {
        this.setAsciiArtMode(asciiArtMode);
        return this;
    }

    public AsciiArtBuilder withPixmapRatioMode(PixmapRatioMode pixmapRatioMode) {
        this.setPixmapRatioMode(pixmapRatioMode);
        return this;
    }

    public AsciiArtBuilder withAsciiColors(char ... cArray) {
        this.setAsciiColors(cArray);
        return this;
    }

    public void setAsciiColors(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        this.setAsciiColors(cArray);
    }

    public AsciiArtBuilder withAsciiColors(String string) {
        this.setAsciiColors(string);
        return this;
    }

    public AsciiArtBuilder withAsciiColorPalette(AsciiColorPalette asciiColorPalette) {
        this.setAsciiColorPalette(asciiColorPalette);
        return this;
    }

    public AsciiArtBuilder withRgbPixmap(RgbPixmap rgbPixmap) {
        this.setRgbPixmap(rgbPixmap);
        return this;
    }

    public void setImageFile(File file) throws IOException {
        this.setRgbPixmap(new RgbPixmapImageBuilder().withImageFile(file).toPixmap());
    }

    public AsciiArtBuilder withImageFile(File file) throws IOException {
        this.setImageFile(file);
        return this;
    }

    public void setImageInputStream(InputStream inputStream) throws IOException {
        this.setRgbPixmap(new RgbPixmapImageBuilder().withImageInputStream(inputStream).toPixmap());
    }

    public AsciiArtBuilder withImageInputStream(InputStream inputStream) throws IOException {
        this.setImageInputStream(inputStream);
        return this;
    }

    public String toString(InputStream inputStream) throws IOException {
        RgbPixmapImageBuilder rgbPixmapImageBuilder = new RgbPixmapImageBuilder().withWidth(this.getColumnWidth());
        return this.toString(rgbPixmapImageBuilder.toPixmap(inputStream));
    }

    public String[] toStrings(InputStream inputStream) throws IOException {
        RgbPixmapImageBuilder rgbPixmapImageBuilder = new RgbPixmapImageBuilder().withWidth(this.getColumnWidth());
        return this.toStrings(rgbPixmapImageBuilder.toPixmap(inputStream));
    }

    public String toString(File file) throws IOException {
        RgbPixmapImageBuilder rgbPixmapImageBuilder = new RgbPixmapImageBuilder().withWidth(this.getColumnWidth());
        return this.toString(rgbPixmapImageBuilder.toPixmap(file));
    }

    public String[] toStrings(File file) throws IOException {
        RgbPixmapImageBuilder rgbPixmapImageBuilder = new RgbPixmapImageBuilder().withWidth(this.getColumnWidth());
        return this.toStrings(rgbPixmapImageBuilder.toPixmap(file));
    }

    public static String[] asAsciiArt(int n, Font font, AsciiArtMode asciiArtMode, String[] stringArray, char ... cArray) {
        return AsciiArtBuilder.asAsciiArt(n, font, asciiArtMode, cArray, stringArray);
    }

    public static String[] asAsciiArt(int n, Font font, AsciiArtMode asciiArtMode, char[] cArray, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Collections.addAll(arrayList, AsciiArtBuilder.asAsciiArt(string, n, font, asciiArtMode, cArray));
            if (i >= stringArray.length - 1) continue;
            arrayList.add(new TextLineBuilder().withLineChar(' ').withColumnWidth(((String)arrayList.get(0)).length()).toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] asAsciiArt(String string, int n, Font font, AsciiArtMode asciiArtMode, char ... cArray) {
        try {
            switch (asciiArtMode) {
                case NORMAL: {
                    if (n != -1) {
                        return AsciiArtBuilder.toAsciiArt(string, n, font, cArray);
                    }
                    if (n == -1 && font.getSize() == -1) {
                        return AsciiArtBuilder.toAsciiArt(string, Terminal.toPreferredTerminalWidth(), font, cArray);
                    }
                    return AsciiArtBuilder.toAsciiArt(string, font, cArray);
                }
                case INVERSE: {
                    if (n != -1) {
                        return AsciiArtBuilder.toInverseAsciiArt(string, n, font, cArray);
                    }
                    if (n == -1 && font.getSize() == -1) {
                        return AsciiArtBuilder.toInverseAsciiArt(string, Terminal.toPreferredTerminalWidth(), font, cArray);
                    }
                    return AsciiArtBuilder.toInverseAsciiArt(string, font, cArray);
                }
            }
            throw new IllegalArgumentException("You must pass a valid ASCII-Art mode, though you actually passed <" + asciiArtMode + ">!");
        }
        catch (Error | Exception throwable) {
            return AsciiArtBuilder.asSimpleBanner(string, n, asciiArtMode, cArray);
        }
    }

    public static String[] asSimpleBanner(String string, int n, AsciiArtMode asciiArtMode, char ... cArray) {
        if (asciiArtMode == AsciiArtMode.INVERSE) {
            char[] cArray2 = new char[cArray.length];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            AsciiArtBuilder.reverseArray(cArray2);
            cArray = cArray2;
        }
        int n2 = 1;
        int n3 = n2 * 2;
        string = CaseStyleBuilder.asKebabCase(string);
        TextBorderBuilder textBorderBuilder = new TextBorderBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        char c = cArray[0];
        if (c != ' ') {
            stringBuilder.append(' ');
        }
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(string.charAt(i));
            if (i >= string.length() - 1) continue;
            stringBuilder.append(' ');
        }
        if (c != ' ') {
            stringBuilder.append(' ');
        }
        string = stringBuilder.toString().toUpperCase();
        HorizAlignTextBuilder horizAlignTextBuilder = new HorizAlignTextBuilder();
        int n4 = string.length() + n3 <= n ? n - n3 : string.length();
        horizAlignTextBuilder.setColumnWidth(n4);
        horizAlignTextBuilder.setFillChar(c);
        horizAlignTextBuilder.setText(new String[]{string});
        horizAlignTextBuilder.setHorizAlignTextMode(HorizAlignTextMode.CENTER);
        string = horizAlignTextBuilder.toString();
        textBorderBuilder.setText(new String[]{string});
        textBorderBuilder.setBorderChar(c);
        textBorderBuilder.setBorderWidth(n2);
        textBorderBuilder.setBoxBorderMode(BoxBorderMode.TOP_RIGHT_BOTTOM_LEFT);
        return textBorderBuilder.toStrings();
    }

    public static String[] asAsciiArt(File file, int n, AsciiArtMode asciiArtMode, PixmapRatioMode pixmapRatioMode, char ... cArray) throws IOException {
        RgbPixmapImageBuilder rgbPixmapImageBuilder = new RgbPixmapImageBuilder().withWidth(n);
        return AsciiArtBuilder.asAsciiArt(rgbPixmapImageBuilder.toPixmap(file), n, asciiArtMode, pixmapRatioMode, cArray);
    }

    public static String[] asAsciiArt(InputStream inputStream, int n, AsciiArtMode asciiArtMode, PixmapRatioMode pixmapRatioMode, char ... cArray) throws IOException {
        RgbPixmapImageBuilder rgbPixmapImageBuilder = new RgbPixmapImageBuilder().withWidth(n);
        return AsciiArtBuilder.asAsciiArt(rgbPixmapImageBuilder.toPixmap(inputStream), n, asciiArtMode, pixmapRatioMode, cArray);
    }

    public static String[] asAsciiArt(RgbPixmap rgbPixmap, int n, AsciiArtMode asciiArtMode, PixmapRatioMode pixmapRatioMode, char ... cArray) {
        int n2;
        RgbPixmap rgbPixmap2 = rgbPixmap;
        int n3 = n2 = n == -1 ? rgbPixmap.getWidth() : n;
        if (n2 != rgbPixmap.getWidth() || pixmapRatioMode != PixmapRatioMode.NONE) {
            int n4;
            BufferedImage bufferedImage = new BufferedImage(rgbPixmap.getWidth(), rgbPixmap.getHeight(), 6);
            for (n4 = 0; n4 < rgbPixmap.getWidth(); ++n4) {
                for (int i = 0; i < rgbPixmap.getHeight(); ++i) {
                    bufferedImage.setRGB(n4, i, ((RgbPixel)rgbPixmap.getPixelAt(n4, i)).toRgbValue());
                }
            }
            n4 = rgbPixmap.getHeight();
            if (pixmapRatioMode != PixmapRatioMode.NONE) {
                n4 = Math.round((float)n2 / (float)rgbPixmap.getWidth() * (float)rgbPixmap.getHeight() * pixmapRatioMode.getRatio());
            }
            Image image = bufferedImage.getScaledInstance(n2, n4, 4);
            bufferedImage = new BufferedImage(n2, n4, 6);
            bufferedImage.getGraphics().drawImage(image, 0, 0, new Color(0, 0, 0), null);
            RgbPixmapBuilderImpl rgbPixmapBuilderImpl = new RgbPixmapBuilderImpl(n2, n4);
            for (int i = 0; i < rgbPixmapBuilderImpl.getWidth(); ++i) {
                for (int j = 0; j < rgbPixmapBuilderImpl.getHeight(); ++j) {
                    rgbPixmapBuilderImpl.setRgbAt(bufferedImage.getRGB(i, j), i, j);
                }
            }
            rgbPixmap2 = rgbPixmapBuilderImpl;
        }
        switch (asciiArtMode) {
            case NORMAL: {
                return AsciiArtBuilder.toAsciiArt(rgbPixmap2, cArray);
            }
            case INVERSE: {
                return AsciiArtBuilder.toInverseAsciiArt(rgbPixmap2, cArray);
            }
        }
        throw new IllegalArgumentException("You must pass a valid ASCII-Art mode, though you actually passed <" + asciiArtMode + ">!");
    }

    protected static String[] toAsciiArt(RgbPixmap rgbPixmap, char[] cArray) {
        String[] stringArray = new String[rgbPixmap.getHeight()];
        for (int i = 0; i < rgbPixmap.getHeight(); ++i) {
            stringArray[i] = "";
            for (int j = 0; j < rgbPixmap.getWidth(); ++j) {
                int n = i;
                stringArray[n] = stringArray[n] + AsciiArtBuilder.toAscii(((RgbPixel)rgbPixmap.getPixelAt(j, i)).toRgbValue(), cArray);
            }
        }
        return stringArray;
    }

    protected static String[] toInverseAsciiArt(RgbPixmap rgbPixmap, char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        AsciiArtBuilder.reverseArray(cArray2);
        return AsciiArtBuilder.toAsciiArt(rgbPixmap, cArray2);
    }

    protected static String[] toAsciiArt(String string, int n, String string2, int n2, char[] cArray) {
        try {
            String[] stringArray = AsciiArtBuilder.toAsciiArt(string, new Font(GraphicalUtility.getAwtFont((String)string, (int)n, (String)string2, (int)n2)), cArray);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == n) continue;
                stringArray[i] = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(new String[]{stringArray[i]})).withColumnWidth(n).withFillChar(cArray[0]).toString();
            }
            return stringArray;
        }
        catch (Error | Exception throwable) {
            return AsciiArtBuilder.asSimpleBanner(string, n, AsciiArtMode.NORMAL, cArray);
        }
    }

    protected static String[] toAsciiArt(String string, int n, Font font, char[] cArray) {
        String string2 = font.getName();
        int n2 = font.getStyle().getCode();
        String[] stringArray = AsciiArtBuilder.toAsciiArt(string, n, string2, n2, cArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == n) continue;
            stringArray[i] = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(new String[]{stringArray[i]})).withColumnWidth(n).withFillChar(cArray[0]).toString();
        }
        return stringArray;
    }

    protected static String[] toInverseAsciiArt(String string, int n, String string2, int n2, char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        AsciiArtBuilder.reverseArray(cArray2);
        return AsciiArtBuilder.toAsciiArt(string, n, string2, n2, cArray2);
    }

    protected static String[] toInverseAsciiArt(String string, int n, Font font, char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        AsciiArtBuilder.reverseArray(cArray2);
        return AsciiArtBuilder.toAsciiArt(string, n, font, cArray2);
    }

    protected static String[] toAsciiArt(String string, int n, String string2, int n2) {
        return AsciiArtBuilder.toAsciiArt(string, n, string2, n2, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }

    protected static String[] toInverseAsciiArt(String string, int n, String string2, int n2) {
        char[] cArray = new char[AsciiColorPalette.MAX_LEVEL_GRAY.getPalette().length];
        System.arraycopy(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette(), 0, cArray, 0, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette().length);
        AsciiArtBuilder.reverseArray(cArray);
        return AsciiArtBuilder.toAsciiArt(string, n, string2, n2, cArray);
    }

    protected static String[] toAsciiArt(String string, Font font) {
        return AsciiArtBuilder.toAsciiArt(string, font, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }

    protected static String[] toInverseAsciiArt(String string, Font font) {
        char[] cArray = new char[AsciiColorPalette.MAX_LEVEL_GRAY.getPalette().length];
        System.arraycopy(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette(), 0, cArray, 0, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette().length);
        AsciiArtBuilder.reverseArray(cArray);
        return AsciiArtBuilder.toAsciiArt(string, font, cArray);
    }

    protected static String[] toAsciiArt(String string, Font font, char[] cArray) {
        int n = 10;
        BufferedImage bufferedImage = new BufferedImage(1, 1, n);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setFont(font.toAwtFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getAscent() + fontMetrics.getHeight() + fontMetrics.getDescent();
        bufferedImage = new BufferedImage(n2, n3, n);
        graphics = bufferedImage.getGraphics();
        graphics.setFont(font.toAwtFont());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawString(string, 0, n3 - fontMetrics.getDescent());
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = n2;
        int n5 = 0;
        block0: for (int i = 0; i < n3; ++i) {
            int n6;
            StringBuilder stringBuilder = new StringBuilder();
            for (n6 = 0; n6 < n2; ++n6) {
                char c = AsciiArtBuilder.toAscii(bufferedImage.getRGB(n6, i), cArray);
                stringBuilder.append(c);
            }
            String string2 = stringBuilder.toString();
            if (string2.trim().isEmpty() || AsciiArtBuilder.isObsolete(string2)) continue;
            arrayList.add(string2);
            for (n6 = 0; n6 < string2.length(); ++n6) {
                if (string2.charAt(n6) == ' ' || n6 >= n4) continue;
                n4 = n6;
                break;
            }
            for (n6 = string2.length() - 1; n6 >= 0; --n6) {
                if (string2.charAt(n6) == ' ' || n6 <= n5) continue;
                n5 = n6;
                continue block0;
            }
        }
        if (n4 == 0 && n5 == n2 - 1) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = ((String)arrayList.get(i)).substring(n4, n5 + 1);
        }
        return stringArray;
    }

    protected static String[] toInverseAsciiArt(String string, Font font, char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        AsciiArtBuilder.reverseArray(cArray2);
        return AsciiArtBuilder.toAsciiArt(string, font, cArray2);
    }

    protected static char toAscii(int n, char[] cArray) {
        float f = 256.0f / (float)cArray.length;
        float f2 = (float)GraphicalUtility.toGray((int)n) / f;
        int n2 = (int)f2;
        char c = cArray[n2];
        return c;
    }

    protected static char toAscii(int n) {
        return AsciiArtBuilder.toAscii(n, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }

    private static boolean isObsolete(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        char c = string.charAt(0);
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            return false;
        }
        return true;
    }

    private static void reverseArray(char[] cArray) {
        for (int i = 0; i < cArray.length / 2; ++i) {
            char c = cArray[i];
            cArray[i] = cArray[cArray.length - i - 1];
            cArray[cArray.length - i - 1] = c;
        }
    }
}

