/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.ext.factory.AbstractCanonicalMapFactory;
import org.refcodes.struct.ext.factory.DocumentProperty;

public class YamlCanonicalMapFactory
extends AbstractCanonicalMapFactory {
    public static final char COMMENT = '#';

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation) throws UnmarshalException {
        return this.fromMarshaled(aExternalRepresentation, null);
    }

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation, Map<String, String> aProperties) throws UnmarshalException {
        char theDelimiter = DocumentProperty.toDelimiter(aProperties, PathMap.DELIMITER);
        ObjectMapper theMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Map theProperties = (Map)theMapper.readValue(aExternalRepresentation, (TypeReference)new TypeReference<Map<Object, Object>>(){});
            CanonicalMapBuilderImpl theResult = new CanonicalMapBuilderImpl((Object)theProperties, theDelimiter);
            this.postProcess((CanonicalMap.CanonicalMapBuilder)theResult);
            return theResult;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aExternalRepresentation) + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aExternalRepresentation) + ">!", (Throwable)e);
        }
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.toMarshaled(aDataStructure, null);
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        ObjectMapper theMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object theDataStructure = aDataStructure.toDataStructure();
        try {
            String theYaml = theMapper.writerWithDefaultPrettyPrinter().writeValueAsString(theDataStructure);
            Object theHead = "";
            String theComment = DocumentProperty.toComment(aProperties);
            if (theComment != null && theComment.length() > 0) {
                String[] theLines;
                for (String eLine : theLines = theComment.split("\\r?\\n")) {
                    theHead = (String)theHead + "# " + eLine + System.lineSeparator();
                }
            }
            return (String)theHead + theYaml;
        }
        catch (JsonProcessingException e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + CanonicalMap.class.getName() + ">.", (Throwable)e);
        }
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.fromUnmarshaled(aDataStructure, null);
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        String theMarshaled = this.toMarshaled(aDataStructure, aProperties);
        ByteArrayInputStream theMarshalledStream = new ByteArrayInputStream(theMarshaled.getBytes());
        return theMarshalledStream;
    }
}

