/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.util.Map;
import java.util.function.Supplier;
import org.refcodes.data.MarshalParameter;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.struct.CanonicalMap;

public enum DocumentProperty implements KeyAccessor<String>
{
    COMMENT(MarshalParameter.COMMENT.getName(), null),
    DELIMITERS(MarshalParameter.DELIMITERS.getName(), null),
    DELIMITER(MarshalParameter.DELIMITER.getName(), null),
    ENVELOPE(MarshalParameter.DOCUMENT_ENVELOPE.getName(), () -> ((SystemProperty)SystemProperty.DOCUMENT_ENVELOPE).getValue()),
    ARRAY_INDEX(MarshalParameter.DOCUMENT_ARRAY_INDEX.getName(), () -> ((SystemProperty)SystemProperty.DOCUMENT_ARRAY_INDEX).getValue());

    private String _key;
    private Supplier<String> _systemProperty;

    private DocumentProperty(String aKey, Supplier<String> aSystemProperty) {
        this._key = aKey;
        this._systemProperty = aSystemProperty;
    }

    public String getKey() {
        return this._key;
    }

    public boolean isTrue(Map<String, String> aProperties) {
        return this._systemProperty != null && this._systemProperty.get() != null && this._systemProperty.get().length() != 0 ? Boolean.valueOf(this._systemProperty.get()) : (aProperties != null ? Boolean.valueOf(aProperties.get(this._key)) : false);
    }

    public String getValue(Map<String, String> aProperties) {
        return this._systemProperty != null && this._systemProperty.get() != null && this._systemProperty.get().length() != 0 ? this._systemProperty.get() : (aProperties != null && aProperties.get(this._key) != null ? aProperties.get(this._key) : null);
    }

    public static char toDelimiter(Map<String, String> aProperties, char aDefaultDelimiter) {
        String theDelimiterString;
        if (aProperties != null && (theDelimiterString = DELIMITER.getValue(aProperties)) != null && theDelimiterString.length() != 0) {
            return theDelimiterString.charAt(0);
        }
        return aDefaultDelimiter;
    }

    public static char[] toDelimiters(Map<String, String> aProperties) {
        String theDelimiterString;
        char[] theDelimiters = null;
        if (aProperties != null && (theDelimiterString = DELIMITERS.getValue(aProperties)) != null && theDelimiterString.length() != 0) {
            theDelimiters = theDelimiterString.toCharArray();
        }
        if (theDelimiters == null) {
            theDelimiters = new char[]{CanonicalMap.DELIMITER};
        }
        return theDelimiters;
    }

    public static String toComment(Map<String, String> aProperties) {
        return COMMENT.getValue(aProperties);
    }

    public static boolean hasEnvelope(Map<String, String> aProperties) {
        return ENVELOPE.isTrue(aProperties);
    }

    public static boolean hasArrayIndex(Map<String, String> aProperties) {
        return ARRAY_INDEX.isTrue(aProperties);
    }
}

