/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.Encrypter;
import org.refcodes.security.EncryptionException;

public class PasswordTextEncrypter
implements Encrypter<String, String, EncryptionException> {
    private static final String CIPHER = "AES/CBC/PKCS5Padding";
    private static final String KEY_FACTORY = "PBKDF2WithHmacSHA256";
    private static final String ALGORITHM = "AES";
    private char[] _password;
    private static final SecureRandom RND = new SecureRandom();

    public PasswordTextEncrypter(char[] aPassword) {
        this._password = SystemContext.HOST_USER_APPLICATION_SESSION.toInvertible(aPassword);
        Arrays.fill(aPassword, '\u0000');
    }

    public PasswordTextEncrypter(String aPassword) {
        this(aPassword.toCharArray());
    }

    @Override
    public String toEncrypted(String aInput) throws EncryptionException {
        String string;
        byte[] theSalt = new byte[8];
        byte[] iv = null;
        byte[] theEncrypted = null;
        byte[] theCombined = null;
        RND.nextBytes(theSalt);
        PBEKeySpec theSpec = new PBEKeySpec(SystemContext.HOST_USER_APPLICATION_SESSION.toInvertible(this._password), theSalt, 65536, 256);
        SecretKeySpec theSecret = null;
        try {
            SecretKeyFactory theFactory = SecretKeyFactory.getInstance(KEY_FACTORY);
            theSecret = new SecretKeySpec(theFactory.generateSecret(theSpec).getEncoded(), ALGORITHM);
            Cipher theCipher = Cipher.getInstance(CIPHER);
            iv = new byte[theCipher.getBlockSize()];
            RND.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            theCipher.init(1, (Key)theSecret, ivSpec);
            theEncrypted = theCipher.doFinal(aInput.getBytes(StandardCharsets.UTF_8));
            theCombined = new byte[theSalt.length + iv.length + theEncrypted.length];
            System.arraycopy(theSalt, 0, theCombined, 0, theSalt.length);
            System.arraycopy(iv, 0, theCombined, theSalt.length, iv.length);
            System.arraycopy(theEncrypted, 0, theCombined, theSalt.length + iv.length, theEncrypted.length);
            string = Base64.getEncoder().encodeToString(theCombined);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            try {
                throw new EncryptionException("Unable to encrypt text as of <" + e.getClass().getName() + ">!", e);
            }
            catch (Throwable throwable) {
                Arrays.fill(theSalt, (byte)0);
                if (theCombined != null) {
                    Arrays.fill(theCombined, (byte)0);
                }
                if (iv != null) {
                    Arrays.fill(iv, (byte)0);
                }
                if (theEncrypted != null) {
                    Arrays.fill(theEncrypted, (byte)0);
                }
                theSpec.clearPassword();
                if (theSecret != null) {
                    try {
                        theSecret.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Arrays.fill(theSalt, (byte)0);
        if (theCombined != null) {
            Arrays.fill(theCombined, (byte)0);
        }
        if (iv != null) {
            Arrays.fill(iv, (byte)0);
        }
        if (theEncrypted != null) {
            Arrays.fill(theEncrypted, (byte)0);
        }
        theSpec.clearPassword();
        if (theSecret != null) {
            try {
                theSecret.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public int toEncrypted(byte[] aBuffer, int aOffset, int aLength, byte[] aOutBuffer, int aOutOffset) throws EncryptionException {
        String theInput = new String(aBuffer, aOffset, aLength, StandardCharsets.ISO_8859_1);
        byte[] theEcrypted = this.toEncrypted(theInput).getBytes(StandardCharsets.ISO_8859_1);
        for (int i = 0; i < theEcrypted.length; ++i) {
            aOutBuffer[i + aOffset] = theEcrypted[i];
        }
        return aLength;
    }

    public void dispose() {
        Arrays.fill(this._password, '\u0000');
    }
}

