/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.mixin.Disposable;
import org.refcodes.security.Encrypter;
import org.refcodes.security.EncryptionException;

public class EncryptionOutputStream
extends OutputStream
implements Disposable {
    private OutputStream _outputStream;
    private Encrypter<byte[], byte[], EncryptionException> _encrypter;

    public EncryptionOutputStream(OutputStream outputStream, Encrypter<byte[], byte[], EncryptionException> encrypter) {
        this._outputStream = outputStream;
        this._encrypter = encrypter;
    }

    public boolean equals(Object object) {
        return this._outputStream.equals(object);
    }

    @Override
    public void flush() throws IOException {
        this._outputStream.flush();
    }

    public int hashCode() {
        return this._outputStream.hashCode();
    }

    @Override
    public void write(int n) throws IOException {
        try {
            this._outputStream.write(Byte.toUnsignedInt(this._encrypter.toEncrypted(new byte[]{(byte)n})[0]));
        }
        catch (EncryptionException encryptionException) {
            throw new IllegalStateException(encryptionException.getMessage(), (Throwable)((Object)encryptionException));
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            this._outputStream.write(this._encrypter.toEncrypted(byArray));
        }
        catch (EncryptionException encryptionException) {
            throw new IllegalStateException(encryptionException.getMessage(), (Throwable)((Object)encryptionException));
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n == 0 && n2 == byArray.length) {
            this.write(byArray);
        } else {
            try {
                byte[] byArray2 = new byte[n2];
                this._encrypter.toEncrypted(byArray, n, n2, byArray2, 0);
                this._outputStream.write(byArray2);
            }
            catch (EncryptionException encryptionException) {
                throw new IllegalStateException(encryptionException.getMessage(), (Throwable)((Object)encryptionException));
            }
        }
    }

    @Override
    public void close() throws IOException {
        OutputStream outputStream;
        Encrypter<byte[], byte[], EncryptionException> encrypter = this._encrypter;
        if (encrypter != null) {
            try {
                encrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._encrypter = null;
        }
        if ((outputStream = this._outputStream) != null) {
            try {
                outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            outputStream.close();
            this._outputStream = null;
        }
    }

    public void dispose() {
        OutputStream outputStream;
        Encrypter<byte[], byte[], EncryptionException> encrypter = this._encrypter;
        if (encrypter != null) {
            try {
                encrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._encrypter = null;
        }
        if ((outputStream = this._outputStream) != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._outputStream = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [outputStream=" + this._outputStream + ", encrypter=" + this._encrypter + "]";
    }
}

