/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.OutputStreamWriter;
import java.util.function.IntSupplier;
import org.fusesource.jansi.AnsiConsole;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemUtility;

public enum Terminal {
    XTERM,
    CYGWIN,
    UNKNOWN;

    private static Boolean _isAnsiTerminal;
    private static Boolean _isCygwinTerminal;
    private static Integer _terminalHeight;
    private static Integer _terminalWidth;
    private static long _lastTerminalHeightUpdate;
    private static long _lastTerminalWidthUpdate;
    private static boolean _canTput;
    private static boolean _canBashTput;
    private static boolean _canModeCon;
    private static boolean _canCmdModeCon;
    private static boolean _canPowershell;
    private static boolean _canStty;
    private static boolean _canBashStty;
    private static boolean _canNativeWindows;
    private static boolean _canBashTputExe;
    private static boolean _canTputExe;
    private static boolean _canBashSttyExe;
    private static boolean _canSttyExe;
    private static final int WIDTH_ABOVE_UNREALSITIC = 1024;
    private static final int HEIGHT_ABOVE_UNREALSITIC = 256;
    private static final int PRESET_TERMINAL_HEIGHT = 25;
    private static final int PRESET_TERMINAL_WIDTH = 80;
    private static final int PRESET_WINCMD_WIDTH = 120;

    private static int getAnsiconHeight() {
        try {
            return Terminal.toAnsiconHeight(EnvironmentVariable.ANSICON.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static int getAnsiconWidth() {
        try {
            return Terminal.toAnsiconWidth(EnvironmentVariable.ANSICON.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int getCurrentTerminalHeight() {
        return Terminal.getTerminalHeight(0);
    }

    public static int getCurrentTerminalWidth() {
        return Terminal.getTerminalWidth(0);
    }

    public static String getLineBreak() {
        String string = SystemProperty.CONSOLE_LINE_BREAK.getValue();
        if (!(string != null && string.length() != 0 || (string = EnvironmentVariable.CONSOLE_LINE_BREAK.getValue()) != null && string.length() != 0)) {
            string = System.lineSeparator();
        }
        if (string == null || string.length() == 0) {
            string = OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? "\r\n" : "\n";
        }
        return string;
    }

    private static int getModeConHeight() {
        if (_canModeCon) {
            try {
                String string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "mode.com con");
                return Terminal.toModeConHeight(string);
            }
            catch (Exception exception) {
                _canModeCon = false;
            }
        }
        if (_canCmdModeCon) {
            try {
                String string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "cmd.exe", "/c", "mode con");
                return Terminal.toModeConHeight(string);
            }
            catch (Exception exception) {
                _canCmdModeCon = false;
            }
        }
        return -1;
    }

    private static int getModeConWidth() {
        if (_canModeCon) {
            try {
                String string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "mode.com con");
                return Terminal.toModeConWidth(string);
            }
            catch (Exception exception) {
                _canModeCon = false;
            }
        }
        if (_canCmdModeCon) {
            try {
                String string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "cmd.exe", "/c", "mode con");
                return Terminal.toModeConWidth(string);
            }
            catch (Exception exception) {
                _canCmdModeCon = false;
            }
        }
        return -1;
    }

    private static int getNativeWindowsWidth() {
        if (_canNativeWindows) {
            try {
                return AnsiConsole.getTerminalWidth();
            }
            catch (Error error) {
                _canNativeWindows = false;
            }
        }
        return -1;
    }

    private static int getPowershellHeight() {
        if (_canPowershell) {
            try {
                String string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "powershell.exe", "/c", "$host.UI.RawUI.WindowSize.Height");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canPowershell = false;
            }
        }
        return -1;
    }

    private static int getPowershellWidth() {
        if (_canPowershell) {
            try {
                String string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "powershell.exe", "/c", "$host.UI.RawUI.WindowSize.Width");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canPowershell = false;
            }
        }
        return -1;
    }

    private static int getSttyExeHeight() {
        String[] stringArray;
        String string;
        if (_canSttyExe) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "stty.exe size");
                if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
                    return Integer.parseInt(stringArray[0]);
                }
            }
            catch (Exception exception) {
                _canSttyExe = false;
            }
        }
        if (_canBashSttyExe) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash.exe", "-c", "stty size");
                if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
                    return Integer.parseInt(stringArray[0]);
                }
            }
            catch (Exception exception) {
                _canBashSttyExe = false;
            }
        }
        return -1;
    }

    private static int getSttyExeWidth() {
        String[] stringArray;
        String string;
        if (_canSttyExe) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "stty.exe size");
                if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
                    return Integer.parseInt(stringArray[1]);
                }
            }
            catch (Exception exception) {
                _canSttyExe = false;
            }
        }
        if (_canBashSttyExe) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash.exe", "-c", "stty size");
                if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
                    return Integer.parseInt(stringArray[1]);
                }
            }
            catch (Exception exception) {
                _canBashSttyExe = false;
            }
        }
        return -1;
    }

    private static int getSttyHeight() {
        String[] stringArray;
        String string;
        if (_canStty) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "stty size");
                if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
                    return Integer.parseInt(stringArray[0]);
                }
            }
            catch (Exception exception) {
                _canStty = false;
            }
        }
        if (_canBashStty) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash", "-c", "stty size");
                if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
                    return Integer.parseInt(stringArray[0]);
                }
            }
            catch (Exception exception) {
                _canBashStty = false;
            }
        }
        return -1;
    }

    private static int getSttyWidth() {
        String[] stringArray;
        String string;
        if (_canStty) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "stty size");
                if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
                    return Integer.parseInt(stringArray[1]);
                }
            }
            catch (Exception exception) {
                _canStty = false;
            }
        }
        if (_canBashStty) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash", "-c", "stty size");
                if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
                    return Integer.parseInt(stringArray[1]);
                }
            }
            catch (Exception exception) {
                _canBashStty = false;
            }
        }
        return -1;
    }

    private static int getTerminalColumns() {
        String string = EnvironmentVariable.TERMINAL_COLUMNS.getValue();
        if (string != null) {
            try {
                return Integer.valueOf(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static String getTerminalEncoding() {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        return outputStreamWriter.getEncoding();
    }

    public static int getTerminalHeight() {
        return Terminal.getTerminalHeight(-1);
    }

    public static int getTerminalHeight(int n) {
        if (_terminalHeight != null && n != 0 && (n == -1 || _lastTerminalHeightUpdate + (long)n > System.currentTimeMillis())) {
            return _terminalHeight;
        }
        int n2 = -1;
        n2 = Terminal.toTerminalHeight(n2, Terminal::getAnsiconHeight);
        n2 = Terminal.toTerminalHeight(n2, Terminal::getTerminalLines);
        if (Terminal.isCygwinTerminal()) {
            n2 = Terminal.toTerminalHeight(n2, Terminal::getTputExeHeight);
            n2 = Terminal.toTerminalHeight(n2, Terminal::getSttyExeHeight);
            n2 = Terminal.toTerminalHeight(n2, Terminal::getPowershellHeight);
            n2 = Terminal.toTerminalHeight(n2, Terminal::getModeConHeight);
        }
        OperatingSystem operatingSystem = OperatingSystem.toOperatingSystem();
        switch (operatingSystem) {
            case MAC: {
                n2 = Terminal.toTerminalHeight(n2, Terminal::getTputHeight);
                n2 = Terminal.toTerminalHeight(n2, Terminal::getSttyHeight);
                break;
            }
            case UNIX: {
                n2 = Terminal.toTerminalHeight(n2, Terminal::getTputHeight);
                n2 = Terminal.toTerminalHeight(n2, Terminal::getSttyHeight);
                break;
            }
            case UNKNOWN: {
                n2 = Terminal.toTerminalHeight(n2, Terminal::getTputHeight);
                n2 = Terminal.toTerminalHeight(n2, Terminal::getTputExeHeight);
                n2 = Terminal.toTerminalHeight(n2, Terminal::getSttyHeight);
                n2 = Terminal.toTerminalHeight(n2, Terminal::getSttyExeHeight);
                n2 = Terminal.toTerminalHeight(n2, Terminal::getPowershellHeight);
                n2 = Terminal.toTerminalHeight(n2, Terminal::getModeConHeight);
                break;
            }
            case WINDOWS: {
                n2 = Terminal.toTerminalHeight(n2, Terminal::getPowershellHeight);
                n2 = Terminal.toTerminalHeight(n2, Terminal::getModeConHeight);
                break;
            }
            default: {
                throw new BugException("Missing case statement for <" + operatingSystem + "> in implementation!");
            }
        }
        if (Terminal.isUnrealsiticHeight(n2)) {
            n2 = -1;
        }
        _terminalHeight = n2;
        _lastTerminalHeightUpdate = System.currentTimeMillis();
        return n2;
    }

    private static int getTerminalLines() {
        String string = EnvironmentVariable.TERMINAL_LINES.getValue();
        if (string != null) {
            try {
                return Integer.valueOf(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getTerminalWidth() {
        return Terminal.getTerminalWidth(-1);
    }

    public static int getTerminalWidth(int n) {
        if (_terminalWidth != null && n != 0 && (n == -1 || _lastTerminalWidthUpdate + (long)n > System.currentTimeMillis())) {
            return _terminalWidth;
        }
        int n2 = -1;
        n2 = Terminal.toTerminalWidth(n2, Terminal::getAnsiconWidth);
        n2 = Terminal.toTerminalWidth(n2, Terminal::getTerminalColumns);
        n2 = Terminal.toTerminalWidth(n2, Terminal::getNativeWindowsWidth);
        if (Terminal.isCygwinTerminal()) {
            n2 = Terminal.toTerminalWidth(n2, Terminal::getTputExeWidth);
            n2 = Terminal.toTerminalWidth(n2, Terminal::getSttyExeWidth);
            n2 = Terminal.toTerminalWidth(n2, Terminal::getPowershellWidth);
            n2 = Terminal.toTerminalWidth(n2, Terminal::getModeConWidth);
        }
        OperatingSystem operatingSystem = OperatingSystem.toOperatingSystem();
        switch (operatingSystem) {
            case MAC: {
                n2 = Terminal.toTerminalWidth(n2, Terminal::getTputWidth);
                n2 = Terminal.toTerminalWidth(n2, Terminal::getSttyWidth);
                break;
            }
            case UNIX: {
                n2 = Terminal.toTerminalWidth(n2, Terminal::getTputWidth);
                n2 = Terminal.toTerminalWidth(n2, Terminal::getSttyWidth);
                break;
            }
            case UNKNOWN: {
                n2 = Terminal.toTerminalWidth(n2, Terminal::getTputWidth);
                n2 = Terminal.toTerminalWidth(n2, Terminal::getTputExeWidth);
                n2 = Terminal.toTerminalWidth(n2, Terminal::getSttyWidth);
                n2 = Terminal.toTerminalWidth(n2, Terminal::getSttyExeWidth);
                n2 = Terminal.toTerminalWidth(n2, Terminal::getPowershellWidth);
                n2 = Terminal.toTerminalWidth(n2, Terminal::getModeConWidth);
                break;
            }
            case WINDOWS: {
                n2 = Terminal.toTerminalWidth(n2, Terminal::getPowershellWidth);
                n2 = Terminal.toTerminalWidth(n2, Terminal::getModeConWidth);
                break;
            }
            default: {
                throw new BugException("Missing case statement for <" + operatingSystem + "> in implementation!");
            }
        }
        if (Terminal.isUnrealsiticWidth(n2)) {
            n2 = -1;
        }
        _terminalWidth = n2;
        _lastTerminalWidthUpdate = System.currentTimeMillis();
        return n2;
    }

    private static int getTputExeHeight() {
        String string;
        if (_canTputExe) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "tput.exe lines");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canTputExe = false;
            }
        }
        if (_canBashTputExe) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash.exe", "-c", "tput lines");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canBashTputExe = false;
            }
        }
        return -1;
    }

    private static int getTputExeWidth() {
        String string;
        if (_canTputExe) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "tput.exe cols");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canTputExe = false;
            }
        }
        if (_canBashTputExe) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash.exe", "-c", "tput cols");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canBashTputExe = false;
            }
        }
        return -1;
    }

    private static int getTputHeight() {
        String string;
        if (_canTput) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "tput lines");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canTput = false;
            }
        }
        if (_canBashTput) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash", "-c", "tput lines");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canBashTput = false;
            }
        }
        return -1;
    }

    private static int getTputWidth() {
        String string;
        if (_canTput) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "tput cols");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canTput = false;
            }
        }
        if (_canBashTput) {
            try {
                string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash", "-c", "tput cols");
                if (string != null) {
                    return Integer.parseInt(string.trim());
                }
            }
            catch (Exception exception) {
                _canBashTput = false;
            }
        }
        return -1;
    }

    public static boolean isAnsiTerminal() {
        if (_isAnsiTerminal != null) {
            return _isAnsiTerminal;
        }
        if (EnvironmentVariable.ANSICON.getValue() != null && EnvironmentVariable.ANSICON.getValue().length() != 0) {
            _isAnsiTerminal = true;
        } else if (Terminal.isCygwinTerminal()) {
            _isAnsiTerminal = true;
        } else if (Shell.toShell() == Shell.POWER_SHELL) {
            _isAnsiTerminal = true;
        } else if (Shell.toShell() == Shell.WIN_CMD) {
            _isAnsiTerminal = true;
        } else {
            int n;
            String string;
            if (_canTput) {
                try {
                    string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "tput colors");
                    if (string != null && (n = Integer.parseInt(string.trim())) > 4) {
                        _isAnsiTerminal = true;
                    }
                }
                catch (Exception exception) {
                    _canTput = false;
                }
            }
            if (_isAnsiTerminal == null && _canBashTput) {
                try {
                    string = SystemUtility.exec(DaemonLoopSleepTime.MIN.getTimeInMs(), "bash", "-c", "tput colors");
                    if (string != null && (n = Integer.parseInt(string.trim())) > 4) {
                        _isAnsiTerminal = true;
                    }
                }
                catch (Exception exception) {
                    _canBashTput = false;
                }
            }
        }
        if (_isAnsiTerminal == null) {
            _isAnsiTerminal = false;
        }
        return _isAnsiTerminal;
    }

    public static boolean isAnsiTerminalPreferred() {
        String string = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_ANSI, EnvironmentVariable.CONSOLE_ANSI, EnvironmentVariable.CONSOLE_CONEMU_ANSI);
        if (string != null) {
            try {
                return NumericalUtility.toBoolean((String)string.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Terminal.isAnsiTerminal();
    }

    public static boolean isCurrentlyLineBreakRequired(int n) {
        return Terminal.isLineBreakRequired(n, 0);
    }

    static boolean isCygwinTerminal() {
        if (_isCygwinTerminal != null) {
            return _isCygwinTerminal;
        }
        _isCygwinTerminal = false;
        if ("cygwin".equalsIgnoreCase(EnvironmentVariable.TERM.getValue())) {
            _isCygwinTerminal = true;
        }
        return _isCygwinTerminal;
    }

    public static boolean isLineBreakRequired(int n) {
        return Terminal.isLineBreakRequired(n, -1);
    }

    public static boolean isLineBreakRequired(int n, int n2) {
        if (RuntimeUtility.isUnderTest() && (n == 80 || n == 120)) {
            return true;
        }
        if (Shell.toShell() == Shell.NONE) {
            return true;
        }
        int n3 = Terminal.getTerminalWidth(n2);
        if (OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && n == n3) {
            try {
                float f = Float.parseFloat(OperatingSystem.WINDOWS.getVersion());
                if (f < 10.0f) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private static boolean isReconsiderableHeight(int n) {
        return n <= 1 || n > 256 || n == 25;
    }

    private static boolean isReconsiderableWidth(int n) {
        return n <= 1 || n > 1024 || n == 80;
    }

    private static boolean isUnrealsiticHeight(int n) {
        return n <= 1 || n > 256;
    }

    private static boolean isUnrealsiticWidth(int n) {
        return n <= 1 || n > 1024;
    }

    static int toAnsiconHeight(String string) throws NumberFormatException {
        int n;
        if (string != null && (n = string.lastIndexOf("x")) != -1 && string.length() > n + 1) {
            if ((string = string.substring(n + 1)).length() != 0 && string.endsWith(")")) {
                string = string.substring(0, string.length() - 1);
            }
            return Integer.valueOf(string.toString());
        }
        throw new NumberFormatException("Cannot extract width from ANSICON formatted value <" + string + ">.");
    }

    static int toAnsiconWidth(String string) throws NumberFormatException {
        int n;
        if (string != null && (n = string.indexOf("x")) != -1) {
            string = string.substring(0, n);
            return Integer.valueOf(string.toString());
        }
        throw new NumberFormatException("Cannot extract width from ANSICON formatted value <" + string + ">.");
    }

    public static String toLineBreak(int n) {
        if (Terminal.isLineBreakRequired(n)) {
            return Terminal.getLineBreak();
        }
        return "\r";
    }

    static int toModeConHeight(String string) throws NumberFormatException {
        return Terminal.toModeConValue(string, 3);
    }

    static int toModeConValue(String string, int n) throws NumberFormatException {
        try {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < n - 1; ++n2) {
                n3 = string.indexOf(58);
                if (n3 == -1 || n3 == string.length() - 1) {
                    return -1;
                }
                string = string.substring(n3 + 1);
            }
            string = string.trim();
            n3 = -1;
            n2 = 0;
            while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                n3 = n2++;
            }
            if (n3 == -1) {
                return -1;
            }
            string = string.substring(0, n3 + 1);
            n2 = Integer.parseInt(string);
            return n2;
        }
        catch (Exception exception) {
            throw new NumberFormatException("Cannot extract the value from \"mode con\" formatted value <" + string + "> for row <" + n + ">.");
        }
    }

    static int toModeConWidth(String string) throws NumberFormatException {
        return Terminal.toModeConValue(string, 4);
    }

    public static int toPreferredTerminalHeight() {
        int n = -1;
        String string = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_HEIGHT, EnvironmentVariable.CONSOLE_HEIGHT);
        if (string != null) {
            try {
                n = Integer.valueOf(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n <= 1) {
            n = Terminal.getTerminalHeight();
        }
        if (n < ConsoleDimension.MIN_HEIGHT.getValue() || n > 256) {
            n = ConsoleDimension.MIN_HEIGHT.getValue();
        }
        return n;
    }

    public static int toPreferredTerminalWidth() {
        int n = -1;
        String string = SystemUtility.toPropertyValue(SystemProperty.CONSOLE_WIDTH, EnvironmentVariable.CONSOLE_WIDTH);
        if (string != null) {
            try {
                n = Integer.valueOf(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n <= 1) {
            n = Terminal.getTerminalWidth();
        }
        if (n < ConsoleDimension.MIN_WIDTH.getValue() || n > 1024) {
            n = ConsoleDimension.MIN_WIDTH.getValue();
        }
        return n;
    }

    public static Terminal toTerminal() {
        String string = EnvironmentVariable.TERM.getValue();
        if (string != null) {
            if ((string = string.toLowerCase()).indexOf("cygwin") >= 0) {
                return CYGWIN;
            }
            if (string.indexOf("xterm") >= 0) {
                return XTERM;
            }
        }
        return UNKNOWN;
    }

    private static int toTerminalHeight(int n, IntSupplier intSupplier) {
        int n2;
        if (Terminal.isReconsiderableHeight(n) && !Terminal.isUnrealsiticHeight(n2 = intSupplier.getAsInt())) {
            return n2;
        }
        return n;
    }

    private static int toTerminalWidth(int n, IntSupplier intSupplier) {
        int n2;
        if (Terminal.isReconsiderableWidth(n) && !Terminal.isUnrealsiticWidth(n2 = intSupplier.getAsInt())) {
            return n2;
        }
        return n;
    }

    static {
        _isAnsiTerminal = null;
        _isCygwinTerminal = null;
        _terminalHeight = null;
        _terminalWidth = null;
        _lastTerminalHeightUpdate = -1L;
        _lastTerminalWidthUpdate = -1L;
        _canTput = true;
        _canBashTput = true;
        _canModeCon = true;
        _canCmdModeCon = true;
        _canPowershell = true;
        _canStty = true;
        _canBashStty = true;
        _canNativeWindows = true;
        _canBashTputExe = true;
        _canTputExe = true;
        _canBashSttyExe = true;
        _canSttyExe = true;
    }
}

