/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.Literal;
import org.refcodes.data.SystemProperty;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.ProcessResult;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.Shell;
import org.refcodes.runtime.SystemContext;
import org.refcodes.runtime.Terminal;

public final class SystemUtility {
    private static String _uname = null;
    private static boolean _hasUname = false;

    private SystemUtility() {
    }

    public static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            String string = EnvironmentVariable.COMPUTERNAME.getValue();
            if (string == null || string.length() == 0) {
                string = EnvironmentVariable.HOSTNAME.getValue();
            }
            if (string != null && string.length() > 0) {
                return string;
            }
            return Literal.LOCALHOST.getValue();
        }
    }

    public static String getUname() {
        if (_hasUname) {
            return _uname;
        }
        try {
            _uname = SystemUtility.exec(DaemonLoopSleepTime.NORM.getTimeInMs(), "uname -a");
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        _hasUname = true;
        return _uname;
    }

    public static String toPropertyValue(String string, SystemProperty systemProperty, EnvironmentVariable ... environmentVariableArray) {
        String string2 = systemProperty.getValue();
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        if (environmentVariableArray != null) {
            for (EnvironmentVariable environmentVariable : environmentVariableArray) {
                string2 = environmentVariable.getValue();
                if (string2 == null || string2.length() <= 0) continue;
                return string2;
            }
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return string;
    }

    public static String toPropertyValue(SystemProperty systemProperty, EnvironmentVariable ... environmentVariableArray) {
        String string = null;
        if (systemProperty != null && (string = systemProperty.getValue()) != null && string.length() != 0) {
            return string;
        }
        if (environmentVariableArray != null) {
            for (EnvironmentVariable environmentVariable : environmentVariableArray) {
                string = environmentVariable.getValue();
                if (string == null || string.length() == 0) continue;
                return string;
            }
        }
        return null;
    }

    public static String exec(int n, String string) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(string);
        Process process = processBuilder.start();
        String string2 = new ProcessResult(process, n).toString();
        return string2;
    }

    public static String exec(int n, String ... stringArray) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        Process process = processBuilder.start();
        String string = new ProcessResult(process, n).toString();
        return string;
    }

    public static String exec(String string) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(string);
        Process process = processBuilder.start();
        String string2 = new ProcessResult(process).toString();
        return string2;
    }

    public static String exec(String ... stringArray) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        Process process = processBuilder.start();
        String string = new ProcessResult(process).toString();
        return string;
    }

    public static Map<String, String> toSystemInfo() {
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("applicationId", NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)SystemContext.APPLICATION.toContextId())));
        int[] nArray = SystemContext.APPLICATION.toContextIds(3);
        Object[] objectArray = new String[3];
        for (n = 0; n < 3; ++n) {
            objectArray[n] = NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)nArray[n]));
        }
        hashMap.put("applicationIds", Arrays.toString(objectArray));
        hashMap.put("applicationString", NumericalUtility.toHexString((String)":", (byte[])SystemContext.APPLICATION.toContextSequence().getBytes()));
        hashMap.put("hostId", NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)SystemContext.HOST.toContextId())));
        nArray = SystemContext.HOST.toContextIds(3);
        for (n = 0; n < 3; ++n) {
            objectArray[n] = NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)nArray[n]));
        }
        hashMap.put("hostIds", Arrays.toString(objectArray));
        hashMap.put("hostString", NumericalUtility.toHexString((String)":", (byte[])SystemContext.HOST.toContextSequence().getBytes()));
        hashMap.put("userId", NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)SystemContext.USER.toContextId())));
        nArray = SystemContext.USER.toContextIds(3);
        for (n = 0; n < 3; ++n) {
            objectArray[n] = NumericalUtility.toHexString((String)":", (byte[])NumericalUtility.toBytes((int)nArray[n]));
        }
        hashMap.put("userIds", Arrays.toString(objectArray));
        hashMap.put("userString", NumericalUtility.toHexString((String)":", (byte[])SystemContext.USER.toContextSequence().getBytes()));
        hashMap.put("computerName", SystemUtility.getComputerName());
        try {
            hashMap.put("ipAddress", NumericalUtility.toHexString((String)":", (byte[])SystemUtility.toHostIpAddress()));
        }
        catch (SocketException | UnknownHostException iOException) {
            hashMap.put("ipAddress", iOException.getMessage());
        }
        hashMap.put("isAnsiTerminalPreferred", "" + Terminal.isAnsiTerminalPreferred());
        hashMap.put("isAnsiTerminal", "" + Terminal.isAnsiTerminal());
        hashMap.put("isCygwinTerminal", "" + Terminal.isCygwinTerminal());
        hashMap.put("isLineBreakRequired", "" + Terminal.isLineBreakRequired(Terminal.getTerminalWidth()));
        hashMap.put("launcherDir", RuntimeUtility.toLauncherDir().getAbsolutePath());
        hashMap.put("lineBreak", Terminal.getLineBreak().replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r"));
        try {
            hashMap.put("macAddress", NumericalUtility.toHexString((String)":", (byte[])SystemUtility.toHostMacAddress()));
        }
        catch (SocketException | UnknownHostException iOException) {
            hashMap.put("macAddress", iOException.getMessage());
        }
        hashMap.put("mainClass", RuntimeUtility.getMainClass().getName());
        hashMap.put("operatingSystem", "" + OperatingSystem.toOperatingSystem());
        hashMap.put("operatingSystemVersion", OperatingSystem.toOperatingSystem().getVersion());
        hashMap.put("preferredTerminalHeight", "" + Terminal.toPreferredTerminalHeight());
        hashMap.put("preferredTerminalWidth", "" + Terminal.toPreferredTerminalWidth());
        hashMap.put("shell", "" + Shell.toShell());
        hashMap.put("systemConsole", System.console() != null ? System.console().toString() : null);
        hashMap.put("terminalEncoding", Terminal.getTerminalEncoding());
        hashMap.put("tempDir", SystemProperty.TEMP_DIR.getValue());
        hashMap.put("terminal", "" + Terminal.toTerminal());
        hashMap.put("terminalHeight", "" + Terminal.getTerminalHeight());
        hashMap.put("terminalWidth", "" + Terminal.getTerminalWidth());
        hashMap.put("uname", SystemUtility.getUname());
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public static String toPrettySystemInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Map<String, String> map = SystemUtility.toSystemInfo();
        int n = -1;
        for (String object : map.keySet()) {
            if (object.length() <= n) continue;
            n = object.length();
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            void var4_7;
            String string;
            String string2 = string = (String)iterator.next();
            while (var4_7.length() < n) {
                String string3 = (String)var4_7 + " ";
            }
            stringBuffer.append((String)var4_7 + " = " + map.get(string) + Terminal.getLineBreak());
        }
        return stringBuffer.toString();
    }

    public static byte[] toHostIpAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                try {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getAddress();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return InetAddress.getLocalHost().getAddress();
    }

    public static byte[] toHostMacAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            byte[] byArray = networkInterface.getHardwareAddress();
            if (byArray == null || byArray.length == 0) continue;
            return byArray;
        }
        try {
            return NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
        }
        catch (SocketException | UnknownHostException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new UnknownHostException("Unable to determine host address: " + exception.getMessage());
        }
    }
}

