/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.component.Openable;
import org.refcodes.rest.RestfulClient;
import org.refcodes.security.StoreType;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;
import org.refcodes.web.BaseUrlAccessor;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.HttpClientContext;
import org.refcodes.web.HttpClientInterceptable;
import org.refcodes.web.OauthToken;
import org.refcodes.web.Url;

public interface RestfulHttpClient
extends RestfulClient,
HttpClientInterceptable,
ConnectionStatusAccessor,
ConnectionComponent<HttpClientContext>,
LinkComponent,
Openable.OpenBuilder<RestfulHttpClient>,
BaseUrlAccessor.BaseUrlProperty,
BaseUrlAccessor.BaseUrlBuilder<RestfulHttpClient>,
TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty,
TrustStoreDescriptorAccessor.TrustStoreDescriptorBuilder<RestfulHttpClient> {
    public static final String DEFAULT_KEYSTORE_TYPE = StoreType.JKS.name();
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";

    default public void open() throws IOException {
        this.open(this.getBaseUrl(), this.getTrustStoreDescriptor());
    }

    default public void open(HttpClientContext aCtx) throws IOException {
        this.open(aCtx.getBaseUrl(), aCtx.getTrustStoreDescriptor());
    }

    default public void open(TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this.open(this.getBaseUrl(), aStoreDescriptor);
    }

    default public void open(Url aBaseUrl) throws IOException {
        this.open(aBaseUrl, this.getTrustStoreDescriptor());
    }

    public void open(Url var1, TrustStoreDescriptor var2) throws IOException;

    default public RestfulHttpClient withOpen() throws IOException {
        this.open();
        return this;
    }

    default public RestfulHttpClient withOpen(HttpClientContext aCtx) throws IOException {
        this.open(aCtx);
        return this;
    }

    default public RestfulHttpClient withOpen(TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this.open(this.getBaseUrl(), aStoreDescriptor);
        return this;
    }

    default public RestfulHttpClient withOpen(Url aBaseUrl) throws IOException {
        this.open(aBaseUrl, this.getTrustStoreDescriptor());
        return this;
    }

    default public RestfulHttpClient withOpen(Url aBaseUrl, TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this.open(aBaseUrl, aStoreDescriptor);
        return this;
    }

    default public RestfulHttpClient withBaseUrl(String aBaseUrl) throws MalformedURLException {
        this.setBaseUrl(aBaseUrl);
        return this;
    }

    default public RestfulHttpClient withBaseUrl(Url aBaseUrl) {
        this.setBaseUrl(aBaseUrl);
        return this;
    }

    default public RestfulHttpClient withBaseUrl(URL aBaseURL) {
        this.setBaseUrl(aBaseURL);
        return this;
    }

    default public RestfulHttpClient withBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this.setBasicAuthCredentials(aBasicAuthCredentials);
        return this;
    }

    default public RestfulHttpClient withBasicAuthCredentials(String aUserName, String aSecret) {
        this.setBasicAuthCredentials(aUserName, aSecret);
        return this;
    }

    default public RestfulHttpClient withOAuthToken(OauthToken aOauthToken) {
        this.setOauthToken(aOauthToken);
        return this;
    }

    default public RestfulHttpClient withTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor) {
        this.setTrustStoreDescriptor(aStoreDescriptor);
        return this;
    }

    default public RestfulHttpClient withUserAgent(String aUserAgent) {
        this.setUserAgent(aUserAgent);
        return this;
    }
}

