/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpPrincipal;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.ThreadingModel;
import org.refcodes.data.Delimiter;
import org.refcodes.data.LatencySleepTime;
import org.refcodes.data.Literal;
import org.refcodes.data.Scheme;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.Trap;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.rest.AbstractRestfulServer;
import org.refcodes.rest.HttpExceptionHandler;
import org.refcodes.rest.HttpExceptionHandling;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.rest.RestfulHttpServer;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.security.KeyStoreDescriptor;
import org.refcodes.web.AuthType;
import org.refcodes.web.BadResponseException;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BasicAuthObserver;
import org.refcodes.web.BasicAuthRequiredException;
import org.refcodes.web.BasicAuthResponse;
import org.refcodes.web.ContentType;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpServerContext;
import org.refcodes.web.HttpServerRequest;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.HttpsConnectionRequestObserver;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.PostHttpServerInterceptor;
import org.refcodes.web.PreHttpServerInterceptor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.TransportLayerProtocol;
import org.refcodes.web.UnsupportedMediaTypeException;
import org.refcodes.web.Url;
import org.refcodes.web.UrlBuilder;

public class HttpRestServer
extends AbstractRestfulServer
implements RestfulHttpServer {
    private static final Logger LOGGER = Logger.getLogger(HttpRestServer.class.getName());
    protected static final String CONTEXT_PATH = "" + Delimiter.PATH.getChar();
    private static final String ANONYMOUS = "anonymous";
    private static final long NO_RESPONSE_BODY = -1L;
    private static final long CHUNCKED_ENCODING = 0L;
    private HttpServer _httpServer = null;
    private int _port = -1;
    private HttpsConnectionRequestObserver _httpsConnectionRequestObserver = null;
    private ExecutorService _executorService;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;
    private HttpBasicAuthenticator _httpBasicAuthenticator = null;
    private HttpContext _httpContext;
    private Scheme _scheme = null;
    private String _protocol = null;
    private KeyStoreDescriptor _keyStoreDescriptor = null;
    private int _maxConnections = -1;
    private HttpExceptionHandling _httpExceptionHandling = HttpExceptionHandling.REPLACE;
    private HttpExceptionHandler _httpExceptionHandler = null;
    private final List<PreHttpServerInterceptor> _preHttpInterceptos = new ArrayList<PreHttpServerInterceptor>();
    private final List<PostHttpServerInterceptor> _postHttpInterceptos = new ArrayList<PostHttpServerInterceptor>();

    public HttpRestServer(ThreadingModel aThreadingModel) {
        this(aThreadingModel, false);
    }

    public HttpRestServer(ThreadingModel aThreadingModel, boolean isVerbose) {
        this(aThreadingModel == ThreadingModel.SINGLE ? null : ControlFlowUtility.createCachedExecutorService((boolean)true), isVerbose);
    }

    public HttpRestServer() {
        this(false);
    }

    public HttpRestServer(boolean isVerbose) {
        this(ControlFlowUtility.createCachedExecutorService((boolean)true), isVerbose);
    }

    public HttpRestServer(ExecutorService aExecutorService) {
        this(aExecutorService, false);
    }

    public HttpRestServer(ExecutorService aExecutorService, boolean isVerbose) {
        super(aExecutorService, isVerbose);
        this._executorService = aExecutorService;
        this._httpExceptionHandler = new DefaultErrorHandler();
    }

    public synchronized void close() throws IOException {
        if (this._connectionStatus != ConnectionStatus.OPENED) {
            throw new IOException("Connection is in status <" + String.valueOf(this._connectionStatus) + ">. Open the connection before closing!");
        }
        try {
            if (this._httpServer != null) {
                this._httpServer.stop(LatencySleepTime.MIN.getTimeMillis() / 1000);
                this._httpServer.removeContext(CONTEXT_PATH);
                this._httpServer = null;
            }
        }
        finally {
            this._connectionStatus = ConnectionStatus.CLOSED;
        }
    }

    @Override
    public void open(String aProtocol, KeyStoreDescriptor aStoreDescriptor, int aPort, int aMaxConnections) throws IOException {
        Scheme theScheme;
        if (aPort < 0) {
            aPort = this.getPort();
        }
        if (aPort < 0) {
            throw new IOException("You must provide a valid port via 'setPort( aPort )' before you can invoke a port-less 'open' method!");
        }
        this._port = aPort;
        if (aProtocol == null) {
            aProtocol = this.toProtocol();
        }
        if ((theScheme = Scheme.fromProtocol((String)aProtocol)) == Scheme.HTTPS) {
            aProtocol = TransportLayerProtocol.TLS.name();
        }
        if (aProtocol == null && aStoreDescriptor != null) {
            if (SystemProperty.LOG_DEBUG.isEnabled() || this._isVerbose) {
                LOGGER.log(Level.INFO, "You did not provide a protocol such as <" + String.valueOf(TransportLayerProtocol.TLS) + "> or <" + Scheme.HTTPS.toProtocol() + ">, falling back <" + String.valueOf(TransportLayerProtocol.TLS) + ">.");
            }
            aProtocol = TransportLayerProtocol.TLS.name();
        }
        if (aStoreDescriptor == null) {
            aStoreDescriptor = this.getKeyStoreDescriptor();
        }
        if (aMaxConnections < 0) {
            aMaxConnections = this.getMaxConnections();
        }
        if (theScheme == null && aProtocol == null || theScheme == Scheme.HTTP) {
            try {
                HttpServer theHttpServer = HttpServer.create();
                theHttpServer.bind(new InetSocketAddress(aPort), aMaxConnections);
                this.open(theHttpServer);
            }
            catch (IOException e) {
                throw new IOException("Unable to bind to port <" + aPort + ">!", e);
            }
        }
        try {
            InetSocketAddress theAddress = new InetSocketAddress(aPort);
            SSLContext theSSLContext = SSLContext.getInstance(aProtocol);
            KeyStore theKeyStore = KeyStore.getInstance(aStoreDescriptor.getStoreType().name());
            FileInputStream theKeystoreInputStream = new FileInputStream(aStoreDescriptor.getStoreFile());
            KeyManagerFactory theKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            TrustManagerFactory theTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            HttpsServer theHttpsServer = HttpsServer.create(theAddress, aMaxConnections);
            theKeyStore.load(theKeystoreInputStream, aStoreDescriptor.getStorePassword().toCharArray());
            theKeyManagerFactory.init(theKeyStore, aStoreDescriptor.getKeyPassword().toCharArray());
            theTrustManagerFactory.init(theKeyStore);
            theSSLContext.init(theKeyManagerFactory.getKeyManagers(), theTrustManagerFactory.getTrustManagers(), null);
            theHttpsServer.setHttpsConfigurator(new HttpsRestConfigurator(theSSLContext));
            theHttpsServer.setExecutor(null);
            this.open(theHttpsServer);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IOException("Unable to bind to port <" + aPort + ">: " + Trap.asMessage((Throwable)e), e);
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    @Override
    public HttpExceptionHandler getHttpExceptionHandler() {
        return this._httpExceptionHandler;
    }

    @Override
    public void setHttpExceptionHandler(HttpExceptionHandler aHttpErrorHandler) {
        this._httpExceptionHandler = aHttpErrorHandler;
    }

    @Override
    public HttpExceptionHandling getHttpExceptionHandling() {
        return this._httpExceptionHandling;
    }

    @Override
    public void setHttpExceptionHandling(HttpExceptionHandling aHttpErrorHandling) {
        this._httpExceptionHandling = aHttpErrorHandling;
    }

    public RestfulHttpServer onConnectionRequest(HttpsConnectionRequestObserver aObserver) {
        this._httpsConnectionRequestObserver = aObserver;
        return this;
    }

    public RestfulHttpServer onBasicAuthRequest(BasicAuthObserver aBasicAuthObserver) {
        HttpContext theHttpContext = this._httpContext;
        HttpBasicAuthenticator theHttpBasicAuthenticator = null;
        if (aBasicAuthObserver != null) {
            theHttpBasicAuthenticator = new HttpBasicAuthenticator(aBasicAuthObserver);
            if (theHttpContext != null) {
                theHttpContext.setAuthenticator(theHttpBasicAuthenticator);
            }
        }
        this._httpBasicAuthenticator = theHttpBasicAuthenticator;
        return this;
    }

    public void setPort(int aPort) {
        this._port = aPort;
    }

    public int getPort() {
        return this._port;
    }

    public void setScheme(Scheme aScheme) {
        this._scheme = aScheme;
        this._protocol = null;
    }

    public Scheme getScheme() {
        return this._scheme;
    }

    public String toProtocol() {
        return this._scheme != null ? this._scheme.toProtocol() : this._protocol;
    }

    public void setProtocol(String aProtocol) {
        Scheme theScheme = Scheme.fromProtocol((String)aProtocol);
        if (theScheme != null) {
            this._scheme = theScheme;
            this._protocol = null;
        } else {
            this._protocol = aProtocol;
            this._scheme = null;
        }
    }

    public KeyStoreDescriptor getKeyStoreDescriptor() {
        return this._keyStoreDescriptor;
    }

    public void setKeyStoreDescriptor(KeyStoreDescriptor aKeyStoreDescriptor) {
        this._keyStoreDescriptor = aKeyStoreDescriptor;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public void setMaxConnections(int aMaxConnections) {
        this._maxConnections = aMaxConnections;
    }

    public boolean hasPreHttpInterceptor(PreHttpServerInterceptor aPreInterceptor) {
        return this._preHttpInterceptos.contains(aPreInterceptor);
    }

    public boolean addPreHttpInterceptor(PreHttpServerInterceptor aPreInterceptor) {
        if (!this._preHttpInterceptos.contains(aPreInterceptor)) {
            return this._preHttpInterceptos.add(aPreInterceptor);
        }
        return false;
    }

    public boolean removePreHttpInterceptor(PreHttpServerInterceptor aPreInterceptor) {
        return this._preHttpInterceptos.remove(aPreInterceptor);
    }

    public boolean hasPostHttpInterceptor(PostHttpServerInterceptor aPostInterceptor) {
        return this._postHttpInterceptos.contains(aPostInterceptor);
    }

    public boolean addPostHttpInterceptor(PostHttpServerInterceptor aPostInterceptor) {
        if (!this._postHttpInterceptos.contains(aPostInterceptor)) {
            return this._postHttpInterceptos.add(aPostInterceptor);
        }
        return false;
    }

    public boolean removePostHttpInterceptor(PostHttpServerInterceptor aPostInterceptor) {
        return this._postHttpInterceptos.remove(aPostInterceptor);
    }

    @Override
    public HttpRestServer withRealm(String aRealm) {
        this.setRealm(aRealm);
        return this;
    }

    public HttpRestServer withCloseUnchecked() {
        this.closeUnchecked();
        return this;
    }

    @Override
    public HttpRestServer withObserversActive(boolean isActive) {
        this.setObserversActive(isActive);
        return this;
    }

    @Override
    public HttpRestServer withEnableObservers() {
        this.enableObservers();
        return this;
    }

    @Override
    public HttpRestServer withDisableObservers() {
        this.disableObservers();
        return this;
    }

    @Override
    public HttpRestServer withOnHttpException(HttpExceptionHandler aHttpExceptionHandler) {
        this.onHttpException(aHttpExceptionHandler);
        return this;
    }

    public HttpRestServer withOpenUnchecked(HttpServerContext aConnection) {
        this.openUnchecked(aConnection);
        return this;
    }

    @Override
    public HttpRestServer withHttpExceptionHandler(HttpExceptionHandler aHttpErrorHandler) {
        this.setHttpExceptionHandler(aHttpErrorHandler);
        return this;
    }

    @Override
    public HttpRestServer withHttpExceptionHandling(HttpExceptionHandling aHttpErrorHandling) {
        this.setHttpExceptionHandling(aHttpErrorHandling);
        return this;
    }

    @Override
    public HttpRestServer withBaseLocator(String aBaseLocator) {
        this.setBaseLocator(aBaseLocator);
        return this;
    }

    @Override
    public HttpRestServer withClose() throws IOException {
        this.close();
        return this;
    }

    @Override
    public HttpRestServer withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    @Override
    public HttpRestServer withCloseIn(int aCloseMillis) {
        this.closeIn(aCloseMillis);
        return this;
    }

    @Override
    public HttpRestServer withOpen(HttpServerContext aConnection) throws IOException {
        this.open(aConnection);
        return this;
    }

    @Override
    public HttpRestServer withOpen(int aPort) throws IOException {
        this.open(aPort);
        return this;
    }

    @Override
    public HttpRestServer withPort(int aPort) {
        this.setPort(aPort);
        return this;
    }

    @Override
    public HttpRestServer withScheme(Scheme aScheme) {
        this.setScheme(aScheme);
        return this;
    }

    @Override
    public HttpRestServer withProtocol(String aProtocol) {
        this.setProtocol(aProtocol);
        return this;
    }

    @Override
    public HttpRestServer withKeyStoreDescriptor(KeyStoreDescriptor aKeyStoreDescriptor) {
        this.setKeyStoreDescriptor(aKeyStoreDescriptor);
        return this;
    }

    @Override
    public HttpRestServer withMaxConnections(int aMaxConnections) {
        this.setMaxConnections(aMaxConnections);
        return this;
    }

    @Override
    protected void preIntercept(HttpServerRequest aRequest, HttpServerResponse aResponse) {
        for (PreHttpServerInterceptor eInterceptor : this._preHttpInterceptos) {
            eInterceptor.preIntercept(aRequest, aResponse);
        }
    }

    @Override
    protected void postIntercept(HttpServerRequest aRequest, HttpServerResponse aResponse) {
        for (PostHttpServerInterceptor eInterceptor : this._postHttpInterceptos) {
            eInterceptor.postIntercept(aRequest, aResponse);
        }
    }

    protected HttpServer getHttpServer() {
        return this._httpServer;
    }

    protected void open(HttpServer aHttpServer) throws IOException {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            throw new IOException("Connection is still in status <" + String.valueOf(this._connectionStatus) + ">. Close the connection before reopening!");
        }
        if (this._executorService != null) {
            aHttpServer.setExecutor(this._executorService);
        }
        HttpContext theHttpContext = aHttpServer.createContext(CONTEXT_PATH, new EndpointHttpHandler());
        HttpBasicAuthenticator theHttpBasicAuthenticator = this._httpBasicAuthenticator;
        if (theHttpBasicAuthenticator != null) {
            theHttpContext.setAuthenticator(theHttpBasicAuthenticator);
        }
        aHttpServer.start();
        this._httpServer = aHttpServer;
        this._httpContext = theHttpContext;
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    private Authenticator.Result toBasicAuthFailure(HttpExchange aHttpExchange) {
        return new Authenticator.Failure(HttpStatusCode.UNAUTHORIZED.getStatusCode());
    }

    private Authenticator.Success toBasicAuthSuccess(String aIdentity) {
        return new Authenticator.Success(new HttpPrincipal(aIdentity, this.getRealm()));
    }

    private Authenticator.Result toBasicAuthRequired(HttpExchange aHttpExchange) {
        Headers theHeaders = aHttpExchange.getResponseHeaders();
        this.doBasicAuthRequired(theHeaders);
        return new Authenticator.Retry(HttpStatusCode.UNAUTHORIZED.getStatusCode());
    }

    private void doBasicAuthRequired(Headers aHeaders) {
        aHeaders.set(HeaderField.WWW_AUTHENTICATE.getName(), "Basic realm=\"" + this.getRealm() + "\"");
    }

    private class HttpBasicAuthenticator
    extends Authenticator {
        private final BasicAuthObserver _basicAuthObserver;

        public HttpBasicAuthenticator(BasicAuthObserver aBasicAuthObserver) {
            this._basicAuthObserver = aBasicAuthObserver;
        }

        @Override
        public Authenticator.Result authenticate(HttpExchange aHttpExchange) {
            Headers theRequestHeaders = aHttpExchange.getRequestHeaders();
            String theAuthHeader = theRequestHeaders.getFirst(HeaderField.AUTHORIZATION.getName());
            BasicAuthCredentials theCredentials = null;
            if (theAuthHeader == null) {
                BasicAuthResponse theBasicAuthResponse = this._basicAuthObserver.onBasicAuthRequest(aHttpExchange.getLocalAddress(), aHttpExchange.getRemoteAddress(), HttpMethod.fromHttpMethod((String)aHttpExchange.getRequestMethod()), aHttpExchange.getRequestURI().getPath(), theCredentials, HttpRestServer.this.getRealm());
                if (theBasicAuthResponse != BasicAuthResponse.BASIC_AUTH_SUCCESS) {
                    return HttpRestServer.this.toBasicAuthRequired(aHttpExchange);
                }
                return new Authenticator.Success(new HttpPrincipal(HttpRestServer.ANONYMOUS, HttpRestServer.this.getRealm()));
            }
            int theMarker = theAuthHeader.indexOf(32);
            if (theMarker == -1 || !theAuthHeader.substring(0, theMarker).equals(AuthType.BASIC.getName())) {
                return HttpRestServer.this.toBasicAuthFailure(aHttpExchange);
            }
            byte[] theCredentialChars = Base64.getDecoder().decode(theAuthHeader.substring(theMarker + 1));
            String theCredentialsText = new String(theCredentialChars);
            theMarker = theCredentialsText.indexOf(58);
            theCredentials = new BasicAuthCredentials(theCredentialsText.substring(0, theMarker), theCredentialsText.substring(theMarker + 1));
            BasicAuthResponse theBasicAuthResponse = this._basicAuthObserver.onBasicAuthRequest(aHttpExchange.getLocalAddress(), aHttpExchange.getRemoteAddress(), HttpMethod.fromHttpMethod((String)aHttpExchange.getRequestMethod()), aHttpExchange.getRequestURI().getPath(), theCredentials, HttpRestServer.this.getRealm());
            if (theBasicAuthResponse == null) {
                throw new NullPointerException("Your <HttpBasicAuthenticator> instance must return an element of type <BasicAuthResponse> and not null.");
            }
            return switch (theBasicAuthResponse) {
                case BasicAuthResponse.BASIC_AUTH_SUCCESS -> HttpRestServer.this.toBasicAuthSuccess(theCredentials.getIdentity());
                case BasicAuthResponse.BASIC_AUTH_REQUIRED -> HttpRestServer.this.toBasicAuthRequired(aHttpExchange);
                case BasicAuthResponse.BASIC_AUTH_FAILURE -> HttpRestServer.this.toBasicAuthFailure(aHttpExchange);
                default -> throw new UnhandledEnumBugException((Enum)theBasicAuthResponse);
            };
        }
    }

    private class DefaultErrorHandler
    implements HttpExceptionHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void onHttpError(RestRequestEvent aRequestEvent, HttpServerResponse aHttpServerResponse, Exception aException, HttpStatusCode aHttpStatusCode) {
            switch (HttpRestServer.this.getHttpExceptionHandling()) {
                case EMPTY: {
                    aHttpServerResponse.setResponse(null);
                    aHttpServerResponse.getHeaderFields().clear();
                    break;
                }
                case KEEP: {
                    break;
                }
                case MERGE: {
                    HttpBodyMap theBodyMap = this.toResponseBodyMap(aHttpServerResponse);
                    if (!theBodyMap.hasStatusCode()) {
                        theBodyMap.putStatusCode(aHttpStatusCode);
                    }
                    if (!theBodyMap.hasStatusAlias()) {
                        theBodyMap.putStatusAlias(aHttpStatusCode);
                    }
                    if (!theBodyMap.hasStatusException()) {
                        theBodyMap.putStatusException(aException);
                    }
                    if (!theBodyMap.hasStatusMessage() && aException.getMessage() != null && aException.getMessage().length() > 0) {
                        theBodyMap.putStatusMessage(aException.getMessage());
                    }
                    if (!theBodyMap.hasStatusTimeStamp()) {
                        theBodyMap.putStatusTimeStamp();
                    }
                    aHttpServerResponse.setResponse((Object)theBodyMap);
                    break;
                }
                case UPDATE: {
                    HttpBodyMap theBodyMap = this.toResponseBodyMap(aHttpServerResponse);
                    theBodyMap.putStatusCode(aHttpStatusCode);
                    theBodyMap.putStatusAlias(aHttpStatusCode);
                    theBodyMap.putStatusException(aException);
                    theBodyMap.putStatusMessage(aException.getMessage());
                    theBodyMap.putStatusTimeStamp();
                    aHttpServerResponse.setResponse((Object)theBodyMap);
                    break;
                }
                case REPLACE: {
                    HttpBodyMap theBodyMap = new HttpBodyMap();
                    theBodyMap.putStatusCode(aHttpStatusCode);
                    theBodyMap.putStatusAlias(aHttpStatusCode);
                    theBodyMap.putStatusException(aException);
                    theBodyMap.putStatusMessage(aException.getMessage());
                    theBodyMap.putStatusTimeStamp();
                    aHttpServerResponse.setResponse((Object)theBodyMap);
                    break;
                }
                default: {
                    throw new UnhandledEnumBugException((Enum)HttpRestServer.this.getHttpExceptionHandling());
                }
            }
        }

        protected HttpBodyMap toResponseBodyMap(HttpServerResponse aHttpServerResponse) {
            HttpBodyMap theHttpBodyMap = null;
            Object theResponse = aHttpServerResponse.getResponse();
            if (theResponse != null) {
                if (theResponse instanceof HttpBodyMap) {
                    theHttpBodyMap = (HttpBodyMap)theResponse;
                } else if (!(theResponse instanceof InputStream)) {
                    theHttpBodyMap = new HttpBodyMap(aHttpServerResponse.getResponse());
                }
            }
            if (theHttpBodyMap == null) {
                theHttpBodyMap = new HttpBodyMap();
            }
            return theHttpBodyMap;
        }
    }

    private class HttpsRestConfigurator
    extends HttpsConfigurator {
        public HttpsRestConfigurator(SSLContext aSSLContext) {
            super(aSSLContext);
        }

        @Override
        public void configure(HttpsParameters aHttpsParams) {
            HttpsConnectionRequestObserver theObserver = HttpRestServer.this._httpsConnectionRequestObserver;
            if (theObserver != null) {
                InetSocketAddress theRemoteAddress = aHttpsParams.getClientAddress();
                HttpServer theServer = HttpRestServer.this.getHttpServer();
                InetSocketAddress theLocalAddress = null;
                if (theServer != null) {
                    theLocalAddress = theServer.getAddress();
                } else {
                    LOGGER.log(Level.WARNING, "Unable to determine the local address for remote address <" + theRemoteAddress.toString() + ">, the server might have been closed in the meantime.");
                }
                SSLContext theSSLContext = this.getSSLContext();
                SSLParameters theSSLParams = theSSLContext.getDefaultSSLParameters();
                theObserver.onHttpsConnectionRequest(theLocalAddress, theRemoteAddress, theSSLParams);
                aHttpsParams.setSSLParameters(theSSLParams);
            }
        }
    }

    private class EndpointHttpHandler
    implements HttpHandler {
        private EndpointHttpHandler() {
        }

        @Override
        public void handle(HttpExchange aHttpExchange) throws IOException {
            HttpMethod theHttpMethod = HttpMethod.fromHttpMethod((String)aHttpExchange.getRequestMethod());
            if (theHttpMethod != null) {
                URI theRequestURI = aHttpExchange.getRequestURI();
                HttpServerResponse theHttpServerResponse = new HttpServerResponse((MediaTypeFactoryLookup)HttpRestServer.this);
                InetSocketAddress theLocalAddress = aHttpExchange.getLocalAddress();
                InetSocketAddress theRemoteAddress = aHttpExchange.getRemoteAddress();
                Headers theRequestHeaders = aHttpExchange.getRequestHeaders();
                RequestHeaderFields theRequestHeaderFields = new RequestHeaderFields((Map)theRequestHeaders);
                UrlBuilder theUrl = new UrlBuilder(theRequestURI.toString());
                if (theUrl.getScheme() == null) {
                    Scheme theScheme = HttpRestServer.this._scheme;
                    if (theScheme == null) {
                        theScheme = TransportLayerProtocol.toScheme((String)HttpRestServer.this._protocol);
                    }
                    theUrl.setScheme(theScheme);
                }
                if (theUrl.getHost() == null) {
                    theUrl.setHost(Literal.LOCALHOST.getValue());
                }
                if (theUrl.getPort() == -1) {
                    theUrl.setPort(HttpRestServer.this._port);
                }
                try {
                    this.onHttpRequest(aHttpExchange, theLocalAddress, theRemoteAddress, theHttpMethod, theUrl, theRequestHeaderFields, aHttpExchange.getRequestBody(), theHttpServerResponse);
                }
                catch (BasicAuthRequiredException e) {
                    HttpRestServer.this.doBasicAuthRequired(aHttpExchange.getResponseHeaders());
                    if (SystemProperty.LOG_DEBUG.isEnabled() || HttpRestServer.this._isVerbose) {
                        LOGGER.log(Level.INFO, "Required HTTP Basic-Authentication with status <" + String.valueOf(e.getStatusCode()) + "> with code <" + e.getStatusCode().getStatusCode() + "> for request URL <" + String.valueOf(theRequestURI) + "> with request method <" + aHttpExchange.getRequestMethod() + ">: " + Trap.asMessage((Throwable)e));
                    }
                    this.onHttpException(aHttpExchange, theLocalAddress, theRemoteAddress, theHttpMethod, theUrl, theRequestHeaderFields, theHttpServerResponse, (Exception)((Object)e), e.getStatusCode());
                }
                catch (HttpStatusException e) {
                    if (SystemProperty.LOG_DEBUG.isEnabled() || HttpRestServer.this._isVerbose) {
                        LOGGER.log(Level.WARNING, "Responding status <" + String.valueOf(e.getStatusCode()) + "> with code <" + e.getStatusCode().getStatusCode() + "> for request URL <" + String.valueOf(theRequestURI) + "> with request method <" + aHttpExchange.getRequestMethod() + "> as of: " + Trap.asMessage((Throwable)e), e);
                    }
                    this.onHttpException(aHttpExchange, theLocalAddress, theRemoteAddress, theHttpMethod, theUrl, theRequestHeaderFields, theHttpServerResponse, (Exception)((Object)e), e.getStatusCode());
                }
                catch (Exception e) {
                    if (SystemProperty.LOG_DEBUG.isEnabled() || HttpRestServer.this._isVerbose) {
                        LOGGER.log(Level.WARNING, "Bad request <" + e.getClass().getName() + "> for request URL <" + String.valueOf(theRequestURI) + "> with request method <" + aHttpExchange.getRequestMethod() + "> as of: " + Trap.asMessage((Throwable)e), e);
                    }
                    this.onHttpException(aHttpExchange, theLocalAddress, theRemoteAddress, theHttpMethod, theUrl, theRequestHeaderFields, theHttpServerResponse, e, HttpStatusCode.BAD_REQUEST);
                }
            } else {
                LOGGER.log(Level.WARNING, "Unknown HTTP-Method <" + aHttpExchange.getRequestMethod() + "> when querying resource locator <" + String.valueOf(aHttpExchange.getLocalAddress()) + ">.");
                aHttpExchange.sendResponseHeaders(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), -1L);
            }
        }

        protected void onHttpException(HttpExchange aHttpExchange, InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, UrlBuilder aUrl, RequestHeaderFields aRequestHeaderFields, HttpServerResponse aHttpServerResponse, Exception aException, HttpStatusCode aHttpStatusCode) throws IOException {
            aHttpServerResponse.setHttpStatusCode(aHttpStatusCode);
            if (HttpRestServer.this._httpExceptionHandler != null) {
                try {
                    RestRequestEvent theRestRequestEvent = new RestRequestEvent(aLocalAddress, aRemoteAddress, aHttpMethod, (Url)aUrl, null, aRequestHeaderFields, aHttpExchange.getRequestBody(), HttpRestServer.this);
                    HttpRestServer.this._httpExceptionHandler.onHttpError(theRestRequestEvent, aHttpServerResponse, aException, aHttpStatusCode);
                    this.finalizeMediaType(aHttpServerResponse);
                    this.doHttpResponse(aHttpExchange, aRequestHeaderFields, aHttpServerResponse, aHttpStatusCode);
                }
                catch (Exception failed) {
                    this.finalizeHttpExceptionResponse(aHttpExchange, aException, !aHttpServerResponse.getHttpStatusCode().isErrorStatus() ? aHttpStatusCode : aHttpServerResponse.getHttpStatusCode());
                }
            } else {
                this.finalizeHttpExceptionResponse(aHttpExchange, aException, aHttpStatusCode);
            }
        }

        protected void finalizeMediaType(HttpServerResponse aHttpServerResponse) {
            ContentType theContentType;
            if (!(aHttpServerResponse.getResponse() == null || (theContentType = aHttpServerResponse.getHeaderFields().getContentType()) != null && HttpRestServer.this.hasMediaTypeFactory(theContentType.getMediaType()))) {
                String theTypeText;
                String string = theTypeText = theContentType != null ? theContentType.toHttpMediaType() : null;
                if (SystemProperty.LOG_DEBUG.isEnabled() || HttpRestServer.this._isVerbose) {
                    LOGGER.log(Level.WARNING, "Unsupported Content-Type <" + theTypeText + "> detected in HTTP-Server-Response, trying fallback ...");
                }
                if (HttpRestServer.this.getFactoryMediaTypes().length == 0) {
                    if (SystemProperty.LOG_DEBUG.isEnabled() || HttpRestServer.this._isVerbose) {
                        LOGGER.log(Level.WARNING, "No fallback Content-Type detected for HTTP-Server-Response as no Media-Type-Factories have been configured ...");
                    }
                } else if (HttpRestServer.this.getFactoryMediaTypes().length != 0) {
                    MediaType theMediaType = HttpRestServer.this.getFactoryMediaTypes()[0];
                    if (SystemProperty.LOG_DEBUG.isEnabled() || HttpRestServer.this._isVerbose) {
                        LOGGER.log(Level.INFO, "Using fallback Content-Type <" + theMediaType.toHttpMediaType() + "> for HTTP-Server-Response ...");
                    }
                    aHttpServerResponse.getHeaderFields().putContentType((HttpMediaType)theMediaType);
                }
            }
        }

        protected void doHttpResponse(HttpExchange aHttpExchange, RequestHeaderFields aRequestHeaderFields, HttpServerResponse aHttpServerResponse, HttpStatusCode aHttpStatusCode) throws IOException, MarshalException, UnsupportedMediaTypeException {
            block11: {
                Headers theResponseHeaders = aHttpExchange.getResponseHeaders();
                for (String eKey : aHttpServerResponse.getHeaderFields().keySet()) {
                    theResponseHeaders.put(eKey, aHttpServerResponse.getHeaderFields().get((Object)eKey));
                }
                Object theResponse = aHttpServerResponse.getResponse();
                if (theResponse instanceof InputStream) {
                    aHttpExchange.sendResponseHeaders(aHttpStatusCode.getStatusCode(), 0L);
                    InputStream theInputStream = (InputStream)theResponse;
                    HttpRestClient.pipe(theInputStream, aHttpExchange.getResponseBody());
                    aHttpExchange.getResponseBody().flush();
                } else {
                    byte[] theBytes = null;
                    if (theResponse != null) {
                        try {
                            theBytes = aHttpServerResponse.toHttpBody().getBytes();
                        }
                        catch (BadResponseException e) {
                            if (SystemProperty.LOG_DEBUG.isEnabled() || HttpRestServer.this._isVerbose) {
                                LOGGER.log(Level.WARNING, "Trying fallback procedure as of: " + Trap.asMessage((Throwable)e), e);
                            }
                            theBytes = HttpRestServer.this.toResponseBody(aHttpServerResponse.getResponse(), aRequestHeaderFields, aHttpServerResponse.getHeaderFields());
                        }
                    }
                    if (theBytes != null && theBytes.length != 0) {
                        aHttpExchange.sendResponseHeaders(aHttpStatusCode.getStatusCode(), theBytes.length);
                        aHttpExchange.getResponseBody().write(theBytes);
                        aHttpExchange.getResponseBody().flush();
                    } else {
                        aHttpExchange.sendResponseHeaders(aHttpStatusCode.getStatusCode(), -1L);
                    }
                }
                try {
                    aHttpExchange.getResponseBody().close();
                }
                catch (AssertionError ignore) {
                    if (!SystemProperty.LOG_DEBUG.isEnabled() && !HttpRestServer.this._isVerbose) break block11;
                    LOGGER.log(Level.WARNING, "Encountered an assertion error as of: " + Trap.asMessage((Throwable)((Object)ignore)), (Throwable)((Object)ignore));
                }
            }
        }

        protected void finalizeHttpExceptionResponse(HttpExchange aHttpExchange, Exception aException, HttpStatusCode aHttpStatusCode) throws IOException {
            LOGGER.log(Level.WARNING, "Unable to fully satisfy <" + String.valueOf((Object)HttpRestServer.this.getHttpExceptionHandling()) + "> mode, falling back to <" + String.valueOf((Object)HttpExceptionHandling.EMPTY) + "> as of: " + Trap.asMessage((Throwable)aException), aException);
            aHttpExchange.sendResponseHeaders(aHttpStatusCode.getStatusCode(), -1L);
            aHttpExchange.getResponseBody().close();
        }

        private void onHttpRequest(HttpExchange aHttpExchange, InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, UrlBuilder aUrl, RequestHeaderFields aRequestHeaderFields, InputStream aHttpInputStream, HttpServerResponse aHttpServerResponse) throws HttpStatusException, MarshalException, IOException {
            HttpRestServer.super.onHttpRequest(aLocalAddress, aRemoteAddress, aHttpMethod, (Url)aUrl, aRequestHeaderFields, aHttpInputStream, aHttpServerResponse);
            HttpStatusCode theHttpStatusCode = aHttpServerResponse.getHttpStatusCode();
            if (theHttpStatusCode == null) {
                theHttpStatusCode = aHttpServerResponse.getResponse() == null ? HttpStatusCode.NO_CONTENT : HttpStatusCode.OK;
            }
            this.doHttpResponse(aHttpExchange, aRequestHeaderFields, aHttpServerResponse, theHttpStatusCode);
        }
    }
}

