/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleMachine;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.rest.AbstractHttpRegistrySidecar;
import org.refcodes.rest.AbstractRestfulHttpServerDecorator;
import org.refcodes.rest.HttpServerDescriptor;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.rest.RestfulHttpRegistryServer;
import org.refcodes.rest.RestfulHttpServer;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.MediaType;
import org.refcodes.web.Url;

public abstract class AbstractRestfulHttpRegistryServerDecorator<DESC extends HttpServerDescriptor, B extends RestfulHttpRegistryServer<DESC, B>>
extends AbstractRestfulHttpServerDecorator<B>
implements RestfulHttpRegistryServer<DESC, B> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRestfulHttpRegistryServerDecorator.class.getName());
    protected LifecycleMachine.ManualLifecycleMachine _lifeCycleAutomaton = new LifecycleMachine.ManualLifecycleMachine();
    private Url _serviceRegistryUrl;
    private DESC _serverDescriptor;
    private TrustStoreDescriptor _storeDescriptor;
    private String _alias;
    private String _instanceId;
    private String _host;
    private String _virtualHost;
    private int[] _ipAddress;
    private String _pingPath;
    protected RestRequestConsumer _pingRequestObserver = null;

    public AbstractRestfulHttpRegistryServerDecorator(RestfulHttpServer aServer) {
        super(aServer);
    }

    public boolean isRunning() {
        return this._lifeCycleAutomaton.isRunning();
    }

    public boolean isInitialized() {
        return this._lifeCycleAutomaton.isInitialized();
    }

    public LifecycleStatus getLifecycleStatus() {
        return this._lifeCycleAutomaton.getLifecycleStatus();
    }

    @Override
    public void pause() throws PauseException {
        this._lifeCycleAutomaton.pause();
    }

    @Override
    public void stop() throws StopException {
        this._lifeCycleAutomaton.stop();
    }

    @Override
    public void start() throws StartException {
        this._lifeCycleAutomaton.start();
    }

    @Override
    public void resume() throws ResumeException {
        this._lifeCycleAutomaton.resume();
    }

    @Override
    public void initialize() throws InitializeException {
        this._lifeCycleAutomaton.initialize();
    }

    public boolean isStoppable() {
        return this._lifeCycleAutomaton.isStoppable();
    }

    public boolean isPausable() {
        return this._lifeCycleAutomaton.isPausable();
    }

    public boolean isStartable() {
        return this._lifeCycleAutomaton.isStartable();
    }

    public boolean isResumable() {
        return this._lifeCycleAutomaton.isResumable();
    }

    public boolean isStopped() {
        return this._lifeCycleAutomaton.isStopped();
    }

    public boolean isPaused() {
        return this._lifeCycleAutomaton.isPaused();
    }

    public boolean isInitalizable() {
        return this._lifeCycleAutomaton.isInitalizable();
    }

    @Override
    public void destroy() {
        this._lifeCycleAutomaton.destroy();
    }

    public boolean isDestroyable() {
        return this._lifeCycleAutomaton.isDestroyable();
    }

    public boolean isDestroyed() {
        return this._lifeCycleAutomaton.isDestroyed();
    }

    public void setInstanceId(String aInstanceId) {
        this._instanceId = aInstanceId;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public void setHost(String aHost) {
        this._host = aHost;
    }

    public String getHost() {
        return this._host;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setVirtualHost(String aVirtualHost) {
        this._virtualHost = aVirtualHost;
    }

    public int[] getIpAddress() {
        return this._ipAddress;
    }

    public void setIpAddress(int[] aIpAddress) {
        this._ipAddress = aIpAddress;
    }

    public TrustStoreDescriptor getTrustStoreDescriptor() {
        return this._storeDescriptor;
    }

    public void setTrustStoreDescriptor(TrustStoreDescriptor aTrustStoreDescriptor) {
        this._storeDescriptor = aTrustStoreDescriptor;
    }

    @Override
    public DESC getHttpServerDescriptor() {
        return this._serverDescriptor;
    }

    @Override
    public void setHttpServerDescriptor(DESC aServerDescriptor) {
        this._serverDescriptor = aServerDescriptor;
    }

    @Override
    public Url getHttpRegistryUrl() {
        return this._serviceRegistryUrl;
    }

    @Override
    public void setHttpRegistryUrl(Url aRegistryUrl) {
        this._serviceRegistryUrl = aRegistryUrl;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setAlias(String aAlias) {
        this._alias = aAlias;
    }

    @Override
    public String getPingPath() {
        return this._pingPath;
    }

    @Override
    public void setPingPath(String aPingPath) {
        this._pingPath = aPingPath;
    }

    @Override
    public void onPingRequest(RestRequestConsumer aRequestConsumer) {
        this._pingRequestObserver = aRequestConsumer;
    }

    @Override
    public RestRequestConsumer getPingRequestObserver() {
        return this._pingRequestObserver;
    }

    protected String toHost(String aHost) throws UnknownHostException {
        return AbstractHttpRegistrySidecar.toHost(aHost, this);
    }

    protected String toVirtualHost(String aVirtualHost) {
        return AbstractHttpRegistrySidecar.toVirtualHost(aVirtualHost, this);
    }

    protected int[] toIpAddress(int[] aIpAddress) throws IOException {
        return AbstractHttpRegistrySidecar.toIpAddress(aIpAddress, this);
    }

    protected String toAlias(String aAlias) {
        return AbstractHttpRegistrySidecar.toAlias(aAlias, this);
    }

    protected Scheme toScheme(Scheme aScheme) {
        return AbstractHttpRegistrySidecar.toScheme(aScheme, this);
    }

    protected int toPort(int aPort) {
        return AbstractHttpRegistrySidecar.toPort(aPort, this);
    }

    protected String toInstanceId(String aInstanceId, String aHost) {
        return AbstractHttpRegistrySidecar.toInstanceId(aInstanceId, aHost, this);
    }

    protected String toPingPath(String aPingPath, String aDefaultPingPath) {
        return AbstractHttpRegistrySidecar.toPingPath(aPingPath, aDefaultPingPath, this);
    }

    protected TrustStoreDescriptor toTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor) {
        return AbstractHttpRegistrySidecar.toTrustStoreDescriptor(aStoreDescriptor, this);
    }

    protected Url toHttpRegistryUrl(Url aRegistryUrl) {
        return AbstractHttpRegistrySidecar.toHttpRegistryUrl(aRegistryUrl, this);
    }

    protected DESC toHttpServerDescriptor(DESC aServerDescriptor) {
        return AbstractHttpRegistrySidecar.toHttpServerDescriptor(aServerDescriptor, this);
    }

    protected RestRequestConsumer toPingObserver(RestRequestConsumer aPingRequestObserver) {
        if (aPingRequestObserver == null && (aPingRequestObserver = this._pingRequestObserver) == null) {
            this._pingRequestObserver = aPingRequestObserver = (aReq, aResp) -> {
                aResp.getHeaderFields().putContentType((HttpMediaType)MediaType.TEXT_PLAIN);
                aResp.setResponse((Object)"Pong!");
                LOGGER.log(Level.INFO, "Received a PING request, no PING handler defined, using default handler!");
            };
        }
        return aPingRequestObserver;
    }
}

