/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.rest.RestClient;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseConsumer;
import org.refcodes.rest.RestResponseEvent;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.FormFields;
import org.refcodes.web.HeaderFieldsAccessor;
import org.refcodes.web.HttpClientRequest;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpRequestBuilder;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.QueryFieldsAccessor;
import org.refcodes.web.RedirectDepthAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlAccessor;
import org.refcodes.web.UrlBuilder;

public class RestResponseHandler
extends HttpClientRequest
implements RestResponseConsumer,
QueryFieldsAccessor.QueryFieldsProperty,
HeaderFieldsAccessor.HeaderFieldsProperty<RequestHeaderFields>,
RedirectDepthAccessor.RedirectDepthBuilder<RestResponseHandler>,
HttpRequestBuilder<RestResponseHandler>,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestResponseHandler>,
LinkComponent.LinkComponentBuilder<RestResponseHandler>,
ConnectionStatusAccessor,
HeaderFieldsAccessor.HeaderFieldsBuilder<RequestHeaderFields, RestResponseHandler> {
    private static Logger LOGGER = Logger.getLogger(RestResponseHandler.class.getName());
    private RestResponseConsumer _responseObserver = null;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestResponseHandler(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, RestResponseConsumer restResponseConsumer, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, requestHeaderFields, object, -1, restResponseConsumer, mediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod httpMethod, Url url, RestResponseConsumer restResponseConsumer, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, null, null, restResponseConsumer, mediaTypeFactoryLookup);
    }

    public RestResponseHandler(MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(null, null, null, null, null, mediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod httpMethod, Url url, Object object, RestResponseConsumer restResponseConsumer, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, null, object, restResponseConsumer, mediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod httpMethod, Url url, RestResponseConsumer restResponseConsumer, int n, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, null, null, n, restResponseConsumer, mediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod httpMethod, Url url, Object object, int n, RestResponseConsumer restResponseConsumer, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, null, object, n, restResponseConsumer, mediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, int n, RestResponseConsumer restResponseConsumer, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, (Url)(url instanceof UrlBuilder ? url : new UrlBuilder(url)), requestHeaderFields, object, n, mediaTypeFactoryLookup);
        this._responseObserver = restResponseConsumer;
    }

    public RestResponseHandler withRedirectDepth(int n) {
        this.setRedirectDepth(n);
        return this;
    }

    public void setQueryFields(FormFields formFields) {
        Url url = this.getUrl();
        UrlBuilder urlBuilder = url instanceof UrlAccessor.UrlBuilder ? (UrlBuilder)url : new UrlBuilder(url);
        urlBuilder.setQueryFields(formFields);
        this.setUrl((Url)urlBuilder);
    }

    public FormFields getQueryFields() {
        return this.getUrl().getQueryFields();
    }

    public RestResponseHandler withUrl(Url url) {
        this.setUrl(url);
        return this;
    }

    public RestResponseHandler withHttpMethod(HttpMethod httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public <REQ> RestResponseHandler withRequest(REQ REQ) {
        this.setRequest(REQ);
        return this;
    }

    @Override
    public void onResponse(RestResponseEvent restResponseEvent) throws HttpResponseException {
        if (this._connectionStatus != ConnectionStatus.CLOSED) {
            this._responseObserver.onResponse(restResponseEvent);
        } else {
            LOGGER.log(Level.WARNING, "Ignoring response <" + restResponseEvent + "> as this rest endpoint is in status <" + this._connectionStatus + ">, you may have closed it already?");
        }
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this._httpMethod = httpMethod;
    }

    public RestResponseConsumer getResponseObserver() {
        return this._responseObserver;
    }

    public void setResponseObserver(RestResponseConsumer restResponseConsumer) {
        this._responseObserver = restResponseConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
        RestResponseHandler restResponseHandler = this;
        synchronized (restResponseHandler) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
        RestResponseHandler restResponseHandler = this;
        synchronized (restResponseHandler) {
            this.notifyAll();
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public void setHeaderFields(RequestHeaderFields requestHeaderFields) {
        this._headerFields = requestHeaderFields;
    }

    public Url getUrl() {
        return this._url;
    }

    public void setUrl(Url url) {
        this._url = url;
    }

    public RestResponseHandler withResponseObserver(RestResponseConsumer restResponseConsumer) {
        this.setResponseObserver(restResponseConsumer);
        return this;
    }

    public RestResponseHandler withHeaderFields(RequestHeaderFields requestHeaderFields) {
        this.setHeaderFields(requestHeaderFields);
        return this;
    }

    public RestResponseHandler withOpen() throws IOException {
        this.open();
        return this;
    }

    public RestResponseHandler withClose() throws IOException {
        this.close();
        return this;
    }

    public RestResponseHandler withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    public RestResponseHandler withCloseIn(int n) {
        this.closeIn(n);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._httpMethod + ": " + this._url.toHttpUrl() + "?" + new VerboseTextBuilder().withElements((Map)this._url.getQueryFields()).toString() + ")@" + this.hashCode();
    }

    public static RestResponseHandler build(RestClient restClient) {
        return new RestResponseHandler((MediaTypeFactoryLookup)restClient);
    }

    static class RestResponseHandlerDaemon
    implements Runnable {
        private RestResponseHandler _responseHandler;
        private RestRequestHandler _requestHandler;
        private RestClient _source;

        protected RestResponseHandlerDaemon(RestResponseHandler restResponseHandler, RestRequestHandler restRequestHandler, RestClient restClient) {
            if (restRequestHandler == null) {
                throw new IllegalArgumentException("Unable to process your request <" + this._responseHandler.toString() + "> as no <" + RestRequestHandler.class.getSimpleName() + "> has been implemented, aborting!");
            }
            this._responseHandler = restResponseHandler;
            this._requestHandler = restRequestHandler;
            this._source = restClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this._responseHandler;
                synchronized (object) {
                    while (this._responseHandler.getConnectionStatus() == ConnectionStatus.NONE) {
                        try {
                            this._responseHandler.wait(DaemonLoopSleepTime.MAX.getTimeInMs());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this._responseHandler.getConnectionStatus() != ConnectionStatus.NONE) continue;
                        LOGGER.log(Level.WARNING, "Your handler's <" + this._responseHandler + "> connection status is still <" + this._responseHandler.getConnectionStatus() + "> after <" + DaemonLoopSleepTime.MAX.getTimeInMs() + "> ms, execution of your request starts not earlier than you calling the #open() method.");
                    }
                }
                if (this._responseHandler.getConnectionStatus() != ConnectionStatus.OPENED) {
                    throw new IllegalStateException("Aborting your request as of your handler <" + this._responseHandler + "> connection status is <" + this._responseHandler.getConnectionStatus() + "> although it is expected to e <" + ConnectionStatus.OPENED + ">.");
                }
                object = this._requestHandler.doRequest(this._responseHandler);
                this._responseHandler.onResponse(new RestResponseEvent((RestResponse)((Object)object), this._source));
            }
            catch (HttpResponseException httpResponseException) {
                LOGGER.log(Level.SEVERE, ExceptionUtility.toMessage((Throwable)httpResponseException), httpResponseException);
            }
        }
    }
}

