/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Port;
import org.refcodes.data.Scheme;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.rest.AbstractRestClient;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.BadRequestException;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpClientRequest;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.ResponseHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlBuilder;

public class HttpRestClientImpl
extends AbstractRestClient
implements HttpRestClient {
    private static Logger LOGGER = Logger.getLogger(HttpRestClientImpl.class.getName());
    private static final int PIPE_STREAM_BUFFER = 1024;
    private Url _baseUrl = null;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;
    private TrustStoreDescriptor _storeDescriptor;

    public HttpRestClientImpl() {
        this.onRestRequest(new HttpRestRequestHandler());
    }

    public HttpRestClientImpl(ExecutorService executorService) {
        super(executorService);
        this.onRestRequest(new HttpRestRequestHandler());
    }

    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    public Url getBaseUrl() {
        return this._baseUrl;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public TrustStoreDescriptor getTrustStoreDescriptor() {
        return this._storeDescriptor;
    }

    @Override
    public void open(Url url, TrustStoreDescriptor trustStoreDescriptor) throws IOException {
        if (trustStoreDescriptor == null) {
            trustStoreDescriptor = this.getTrustStoreDescriptor();
        } else {
            this._storeDescriptor = trustStoreDescriptor;
        }
        if (url == null) {
            url = this.getBaseUrl();
        } else {
            this._baseUrl = url;
        }
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            throw new IOException("The HTTP rest client is already open, close first before opening again!");
        }
        this._connectionStatus = ConnectionStatus.OPENED;
        if (trustStoreDescriptor != null) {
            SystemProperty.TRUST_STORE_FILE.setValue(trustStoreDescriptor.getStoreFile().getAbsolutePath());
            SystemProperty.TRUST_STORE_PASSWORD.setValue(trustStoreDescriptor.getStorePassword() != null ? trustStoreDescriptor.getStorePassword() : "");
            SystemProperty.TRUST_STORE_TYPE.setValue(trustStoreDescriptor.getStoreType().name());
        }
    }

    public void setBaseUrl(Url url) {
        if (url != null) {
            if (url.getScheme() != Scheme.HTTP && url.getScheme() != Scheme.HTTPS) {
                throw new IllegalArgumentException("Cannot use the protocol <" + url.getScheme() + "> to do HTTP requests (" + url.toHttpUrl() + "). You must provide a base URL for protocols <" + Scheme.HTTP.getName() + "> or <" + Scheme.HTTPS.getName() + ">.");
            }
            if (url.getQueryFields() != null && url.getQueryFields().size() != 0) {
                throw new IllegalArgumentException("Cannot use a query <" + new VerboseTextBuilder().withElements((Map)url.getQueryFields()) + "> as bayse path. You must provide a base URL without a query.");
            }
        }
        this._baseUrl = url;
    }

    public void setBaseUrl(URL uRL) {
        this.setBaseUrl(new Url(uRL));
    }

    public void setTrustStoreDescriptor(TrustStoreDescriptor trustStoreDescriptor) {
        this._storeDescriptor = trustStoreDescriptor;
    }

    protected static void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private class HttpRestRequestHandler
    implements RestRequestHandler {
        private HttpRestRequestHandler() {
        }

        @Override
        public RestResponse doRequest(HttpClientRequest httpClientRequest) throws HttpResponseException {
            if (HttpRestClientImpl.this._connectionStatus == ConnectionStatus.CLOSED) {
                throw new IllegalStateException(" Expected a connection status <" + ConnectionStatus.OPENED.name() + ">, unable to produce a HTTP request while the connection is in status <" + HttpRestClientImpl.this._connectionStatus.name() + ">, did you forget to call #open(...)?");
            }
            try {
                Object object;
                HttpURLConnection httpURLConnection = null;
                InetSocketAddress inetSocketAddress = null;
                InetSocketAddress inetSocketAddress2 = null;
                HttpStatusCode httpStatusCode = null;
                ResponseHeaderFields responseHeaderFields = null;
                int n = httpClientRequest.getRedirectDepth();
                if (n < 0) {
                    HttpURLConnection.setFollowRedirects(true);
                    n = 0;
                } else {
                    HttpURLConnection.setFollowRedirects(false);
                }
                Url url = httpClientRequest.getUrl();
                boolean bl = false;
                while (n >= 0) {
                    Object object22;
                    Object object3;
                    Object object4;
                    object = null;
                    try {
                        object = url.toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (HttpRestClientImpl.this._baseUrl == null) {
                            throw new HttpResponseException(HttpStatusCode.INTERNAL_CLIENT_ERROR, "Unable to create a valid URL from locator <" + url.toHttpUrl() + ">: " + ExceptionUtility.toMessage((Throwable)malformedURLException), (Throwable)malformedURLException);
                        }
                        try {
                            object4 = bl ? new UrlBuilder(HttpRestClientImpl.this._baseUrl).withPath(null).toHttpUrl() : HttpRestClientImpl.this._baseUrl.toHttpUrl();
                            object3 = url.toHttpUrl();
                            object22 = "";
                            if (!(object4 != null && ((String)object4).endsWith("" + Delimiter.PATH.getChar()) || object3 != null && ((String)object3).startsWith("" + Delimiter.PATH.getChar()))) {
                                object22 = "" + Delimiter.PATH.getChar();
                            }
                            object = new URL((String)object4 + (String)object22 + (String)object3);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            throw new HttpResponseException(HttpStatusCode.INTERNAL_CLIENT_ERROR, "Unable to create a valid URL from the base URL <" + HttpRestClientImpl.this._baseUrl.toHttpUrl() + "> and the locator <" + url.toHttpUrl() + ">: " + ExceptionUtility.toMessage((Throwable)malformedURLException2), (Throwable)malformedURLException2);
                        }
                    }
                    int n2 = ((URL)object).getPort();
                    if (n2 == -1) {
                        object4 = ((URL)object).getProtocol();
                        if (Scheme.HTTP.getName().equalsIgnoreCase((String)object4)) {
                            n2 = Port.HTTP.getPort();
                        }
                        if (Scheme.HTTPS.getName().equalsIgnoreCase((String)object4)) {
                            n2 = Port.HTTPS.getPort();
                        }
                    }
                    inetSocketAddress2 = new InetSocketAddress(((URL)object).getHost(), n2);
                    inetSocketAddress = InetSocketAddress.createUnresolved(InetAddress.getLocalHost().getHostName(), n2);
                    httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
                    httpURLConnection.setRequestMethod(httpClientRequest.getHttpMethod().name());
                    object4 = httpClientRequest.getHeaderFields().get(HeaderField.ACCEPT);
                    if (object4 == null || object4.size() == 0) {
                        httpClientRequest.getHeaderFields().putAcceptTypes((HttpMediaType[])HttpRestClientImpl.this.getFactoryMediaTypes());
                    }
                    httpURLConnection.setRequestMethod(httpClientRequest.getHttpMethod().name());
                    HttpRestClientImpl.this.doRequestCorrelation(httpClientRequest.getHeaderFields());
                    HttpRestClientImpl.this.doSessionCorrelation(httpClientRequest.getHeaderFields());
                    for (Object object22 : httpClientRequest.getHeaderFields().keySet()) {
                        httpURLConnection.setRequestProperty((String)object22, httpClientRequest.getHeaderFields().toField((String)object22));
                    }
                    object3 = httpClientRequest.getRequest();
                    if (object3 instanceof InputStream) {
                        object22 = (InputStream)object3;
                        httpURLConnection.setDoOutput(true);
                        HttpRestClientImpl.pipe((InputStream)object22, httpURLConnection.getOutputStream());
                        httpURLConnection.getOutputStream().flush();
                    } else {
                        object22 = httpClientRequest.toHttpBody();
                        if (object22 != null) {
                            httpURLConnection.setDoOutput(true);
                            httpURLConnection.getOutputStream().write(((String)object22).getBytes());
                            httpURLConnection.getOutputStream().flush();
                        }
                    }
                    if (!httpClientRequest.getHttpMethod().name().equalsIgnoreCase(httpURLConnection.getRequestMethod())) {
                        LOGGER.log(Level.WARNING, "You issued a request with HTTP-Method <" + httpClientRequest.getHttpMethod().name() + "> which is not applicable for sending a HTTP body, the HTTP-Method has been changed to <" + httpURLConnection.getRequestMethod() + ">.");
                    }
                    responseHeaderFields = new ResponseHeaderFields();
                    object22 = httpURLConnection.getHeaderFields();
                    responseHeaderFields.putAll(object22);
                    HttpRestClientImpl.this.doRequestCorrelation(responseHeaderFields);
                    HttpRestClientImpl.this.doSessionCorrelation(responseHeaderFields);
                    httpStatusCode = HttpStatusCode.toHttpStatusCode((int)httpURLConnection.getResponseCode());
                    if (httpStatusCode.isRedirectStatus() && n > 0) {
                        bl = true;
                        String string = responseHeaderFields.getLocation();
                        UrlBuilder urlBuilder = new UrlBuilder(url);
                        if (string != null) {
                            if (this.isAbsoluteUrl(string)) {
                                int n3;
                                String string2;
                                int[] nArray;
                                String string3;
                                UrlBuilder urlBuilder2 = new UrlBuilder(string);
                                Scheme scheme = urlBuilder2.getScheme();
                                if (scheme != null) {
                                    urlBuilder.setScheme(scheme);
                                }
                                if ((string3 = urlBuilder2.getHost()) != null) {
                                    urlBuilder.setHost(string3);
                                }
                                if ((nArray = urlBuilder2.getIpAddress()) != null && nArray.length > 0) {
                                    urlBuilder.setIpAddress(nArray);
                                }
                                if ((string2 = urlBuilder2.getPath()) != null) {
                                    urlBuilder.setPath(string2);
                                }
                                if ((n3 = urlBuilder2.getPort()) != -1) {
                                    urlBuilder.setPort(n3);
                                }
                            } else {
                                urlBuilder.setPath(string);
                            }
                            url = urlBuilder;
                            --n;
                            continue;
                        }
                        n = -1;
                        continue;
                    }
                    n = -1;
                }
                object = new RestResponse(url, inetSocketAddress, inetSocketAddress2, httpStatusCode, responseHeaderFields, new HttpConnectionInputStream(httpURLConnection), (MediaTypeFactoryLookup)HttpRestClientImpl.this);
                return object;
            }
            catch (IOException iOException) {
                throw new HttpResponseException(HttpStatusCode.INTERNAL_CLIENT_ERROR, this.toMessage(httpClientRequest) + ": " + iOException.getMessage(), (Throwable)iOException);
            }
            catch (BadRequestException badRequestException) {
                throw new HttpResponseException(badRequestException.getStatusCode(), this.toMessage(httpClientRequest) + ": " + badRequestException.getMessage(), (Throwable)badRequestException);
            }
        }

        private boolean isAbsoluteUrl(String string) {
            String string2 = string.toLowerCase();
            if (string2.startsWith(Scheme.HTTP.toProtocol().toLowerCase())) {
                return true;
            }
            return string2.startsWith(Scheme.HTTPS.toProtocol().toLowerCase());
        }

        private String toMessage(HttpClientRequest httpClientRequest) {
            return "Error while processing URL <" + httpClientRequest.getUrl().toHttpUrl() + "> using HTTP-Method <" + httpClientRequest.getHttpMethod().toString() + ">";
        }
    }

    private static class HttpConnectionInputStream
    extends InputStream {
        private InputStream _inputStream;

        public HttpConnectionInputStream(HttpURLConnection httpURLConnection) {
            block2: {
                try {
                    this._inputStream = httpURLConnection.getInputStream();
                }
                catch (IOException iOException) {
                    this._inputStream = httpURLConnection.getErrorStream();
                    if (this._inputStream != null) break block2;
                    String string = iOException.getMessage();
                    this._inputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
                }
            }
        }

        @Override
        public int available() throws IOException {
            return this._inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this._inputStream.close();
        }

        public boolean equals(Object object) {
            return this._inputStream.equals(object);
        }

        public int hashCode() {
            return this._inputStream.hashCode();
        }

        @Override
        public void mark(int n) {
            this._inputStream.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this._inputStream.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this._inputStream.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this._inputStream.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this._inputStream.read(byArray, n, n2);
        }

        @Override
        public void reset() throws IOException {
            this._inputStream.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            return this._inputStream.skip(l);
        }

        public String toString() {
            return this._inputStream.toString();
        }
    }
}

