/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import org.refcodes.mixin.FilenameSuffixesAccessor;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.runtime.ConfigLocator;

public interface ResourcePropertiesFactory
extends FilenameSuffixesAccessor {
    default public boolean hasFilenameSuffix(File aFile) {
        if (aFile != null) {
            return this.hasFilenameSuffix(aFile.getAbsolutePath());
        }
        return false;
    }

    default public boolean hasFilenameSuffix(String aFilePath) {
        if (this.getFilenameSuffixes() != null && aFilePath != null) {
            String theLowerCase = aFilePath.toLowerCase();
            for (String eSuffix : this.getFilenameSuffixes()) {
                if (eSuffix == null || !theLowerCase.endsWith(eSuffix.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    default public ResourceProperties toProperties(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        return this.toProperties(aResourceClass, aFilePath, null);
    }

    public ResourceProperties toProperties(Class<?> var1, String var2, ConfigLocator var3) throws IOException, ParseException;

    default public ResourceProperties toProperties(File aFile) throws IOException, ParseException {
        return this.toProperties(aFile, null);
    }

    public ResourceProperties toProperties(File var1, ConfigLocator var2) throws IOException, ParseException;

    public ResourceProperties toProperties(InputStream var1) throws IOException, ParseException;

    public ResourceProperties toProperties(Map<?, ?> var1);

    public ResourceProperties toProperties(Object var1);

    public ResourceProperties toProperties(Properties var1);

    public ResourceProperties toProperties(Properties.PropertiesBuilder var1);

    default public ResourceProperties toProperties(String aFilePath) throws IOException, ParseException {
        return this.toProperties(null, aFilePath, null);
    }

    default public ResourceProperties toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return this.toProperties(null, aFilePath, aConfigLocator);
    }

    public ResourceProperties toProperties(URL var1) throws IOException, ParseException;

    public static interface ResourcePropertiesBuilderFactory
    extends ResourcePropertiesFactory {
        @Override
        default public ResourceProperties.ResourcePropertiesBuilder toProperties(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
            return this.toProperties((Class)aResourceClass, aFilePath, (ConfigLocator)null);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Class<?> var1, String var2, ConfigLocator var3) throws IOException, ParseException;

        @Override
        default public ResourceProperties.ResourcePropertiesBuilder toProperties(File aFile) throws IOException, ParseException {
            return this.toProperties(aFile, null);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(File var1, ConfigLocator var2) throws IOException, ParseException;

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(InputStream var1) throws IOException, ParseException;

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Map<?, ?> var1);

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Object var1);

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Properties var1);

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Properties.PropertiesBuilder var1);

        @Override
        default public ResourceProperties.ResourcePropertiesBuilder toProperties(String aFilePath) throws IOException, ParseException {
            return this.toProperties((Class)null, aFilePath, (ConfigLocator)null);
        }

        @Override
        default public ResourceProperties.ResourcePropertiesBuilder toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return this.toProperties((Class)null, aFilePath, aConfigLocator);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(URL var1) throws IOException, ParseException;
    }
}

