/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import org.refcodes.matcher.MatcherSchema;
import org.refcodes.observer.AbstractEventMatcher;
import org.refcodes.observer.EventMetaData;
import org.refcodes.observer.MetaDataEvent;
import org.refcodes.schema.Schema;

public class ChannelEqualWithEventMatcher<E extends MetaDataEvent<?, ?>>
extends AbstractEventMatcher<E> {
    public static final String ALIAS = "CHANNEL_EQUAL_WITH";
    private final String _channel;

    public ChannelEqualWithEventMatcher(String aChannel) {
        super(ALIAS, "Matches the given channel <" + aChannel + "> with the channel stored in an event's meta data (CHANNEL EQUAL WITH).");
        this._channel = aChannel;
    }

    @Override
    public boolean isMatching(E aEvent) {
        if (this._channel != null) {
            return this._channel.equals(((EventMetaData)aEvent.getMetaData()).getChannel());
        }
        return ((EventMetaData)aEvent.getMetaData()).getChannel() == null;
    }

    @Override
    public MatcherSchema toSchema() {
        MatcherSchema theSchema = super.toSchema();
        theSchema.put((Object)Schema.VALUE, (Object)this._channel);
        return theSchema;
    }
}

