/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import org.refcodes.matcher.Matcher;
import org.refcodes.matcher.MatcherSugar;
import org.refcodes.mixin.EventMetaData;
import org.refcodes.observer.EventMatcher;
import org.refcodes.observer.GenericActionMetaDataEvent;
import org.refcodes.observer.GenericMetaDataEvent;

public class EventMatcherSugar {
    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> catchAll() {
        return new EventMatcher<E>(){

            @Override
            public boolean isMatching(E e) {
                return true;
            }
        };
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> catchNone() {
        return new EventMatcher<E>(){

            @Override
            public boolean isMatching(E e) {
                return false;
            }
        };
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> isAssignableFrom(Class<?> clazz) {
        Matcher matcher = MatcherSugar.isAssignableFrom(clazz);
        return new EventMatcherWrapper(matcher);
    }

    public static <E extends GenericMetaDataEvent<?, ?>, PT> EventMatcher<E> publisherIsAssignableFrom(Class<? extends PT> clazz) {
        return new PublisherIsAssignableFromMatcherImpl(clazz);
    }

    @SafeVarargs
    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> or(EventMatcher<E> ... eventMatcherArray) {
        return new EventMatcherWrapper(MatcherSugar.or((Matcher[])eventMatcherArray));
    }

    @SafeVarargs
    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> and(EventMatcher<E> ... eventMatcherArray) {
        return new EventMatcherWrapper(MatcherSugar.and((Matcher[])eventMatcherArray));
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> nameEqualWith(String string) {
        return new AliasEqualWithMatcherImpl(string);
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> groupEqualWith(String string) {
        return new GroupEqualWithMatcherImpl(string);
    }

    public static <E extends GenericMetaDataEvent<?, ?>> EventMatcher<E> universalIdEqualWith(String string) {
        return new UniversalIdEqualWithMatcher(string);
    }

    public static <E extends GenericActionMetaDataEvent<A, ?, ?>, A> EventMatcher<E> actionEqualWith(A a) {
        return new ActionEqualWithMatcherImpl(a);
    }

    private static class ActionEqualWithMatcherImpl<E extends GenericActionMetaDataEvent<?, ?, ?>>
    implements EventMatcher<E> {
        private Object _action;

        public <A> ActionEqualWithMatcherImpl(A a) {
            this._action = a;
        }

        @Override
        public boolean isMatching(E e) {
            assert (e != null);
            if (this._action != null) {
                return this._action.equals(e.getAction());
            }
            return e.getAction() == null;
        }
    }

    private static class UniversalIdEqualWithMatcher<E extends GenericMetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private String _universalId;

        public UniversalIdEqualWithMatcher(String string) {
            this._universalId = string;
        }

        @Override
        public boolean isMatching(E e) {
            assert (e != null);
            if (this._universalId != null) {
                return this._universalId.equals(((EventMetaData)e.getMetaData()).getUniversalId());
            }
            return ((EventMetaData)e.getMetaData()).getUniversalId() == null;
        }
    }

    private static class GroupEqualWithMatcherImpl<E extends GenericMetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private String _group;

        public GroupEqualWithMatcherImpl(String string) {
            this._group = string;
        }

        @Override
        public boolean isMatching(E e) {
            assert (e != null);
            if (this._group != null) {
                return this._group.equals(((EventMetaData)e.getMetaData()).getGroup());
            }
            return ((EventMetaData)e.getMetaData()).getGroup() == null;
        }
    }

    private static class AliasEqualWithMatcherImpl<E extends GenericMetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private String _alias;

        public AliasEqualWithMatcherImpl(String string) {
            this._alias = string;
        }

        @Override
        public boolean isMatching(E e) {
            assert (e != null);
            if (this._alias != null) {
                return this._alias.equals(((EventMetaData)e.getMetaData()).getAlias());
            }
            return ((EventMetaData)e.getMetaData()).getAlias() == null;
        }
    }

    private static class PublisherIsAssignableFromMatcherImpl<E extends GenericMetaDataEvent<?, ?>, PT>
    implements EventMatcher<E> {
        private Class<? extends PT> _eventPublisherType;

        public PublisherIsAssignableFromMatcherImpl(Class<? extends PT> clazz) {
            this._eventPublisherType = clazz;
        }

        @Override
        public boolean isMatching(E e) {
            assert (e != null);
            return this._eventPublisherType == null || ((EventMetaData)e.getMetaData()).getPublisherType().isAssignableFrom(this._eventPublisherType);
        }
    }

    private static class EventMatcherWrapper<E extends GenericMetaDataEvent<?, ?>>
    implements EventMatcher<E> {
        private Matcher<E> _eventMatcher;

        public EventMatcherWrapper(Matcher<E> matcher) {
            assert (matcher != null);
            this._eventMatcher = matcher;
        }

        @Override
        public boolean isMatching(E e) {
            return this._eventMatcher.isMatching(e);
        }
    }
}

