/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmImpl;
import org.refcodes.numerical.CrcSize;
import org.refcodes.numerical.Endianess;

public enum CrcStandard implements CrcAlgorithm
{
    CRC_8("CRC-8", 8, 213L, 0L, false, false, 0L),
    CRC_8_ARDUINO("CRC-8/ARDUINO", 8, 140L, 0L, false, false, 0L),
    CRC_8_CCITT("CRC-8/CCITT", 8, 7L, 0L, false, false, 0L),
    CRC_8_CDMA2000("CRC-8/CDMA2000", 8, 155L, 255L, false, false, 0L),
    CRC_8_DARC("CRC-8/DARC", 8, 57L, 0L, true, true, 0L),
    CRC_8_DVBS2("CRC-8/DVB-S2", 8, 213L, 0L, false, false, 0L),
    CRC_8_SAE_J1850("CRC-8/SAE_J1850", 8, 29L, 255L, true, true, 0L),
    CRC_8_EBU("CRC-8/EBU", 8, 29L, 255L, true, true, 0L),
    CRC_8_ICODE("CRC-8/I-CODE", 8, 29L, 253L, false, false, 0L),
    CRC_8_ITU("CRC-8/ITU", 8, 7L, 0L, false, false, 85L),
    CRC_8_MAXIM("CRC-8/MAXIM", 8, 49L, 0L, true, true, 0L),
    CRC_8_ROHC("CRC-8/ROHC", 8, 7L, 255L, true, true, 0L),
    CRC_8_WCDMA("CRC-8/WCDMA", 8, 155L, 0L, true, true, 0L),
    CRC_16_CCITT_FALSE("CRC-16/CCITT-FALSE", 16, 4129L, 65535L, false, false, 0L),
    CRC_16_ARC("CRC-16/ARC", 16, 32773L, 0L, true, true, 0L),
    CRC_16_AUG_CCITT("CRC-16/AUG-CCITT", 16, 4129L, 7439L, false, false, 0L),
    CRC_16_BUYPASS("CRC-16/BUYPASS", 16, 32773L, 0L, false, false, 0L),
    CRC_16_CDMA2000("CRC-16/CDMA2000", 16, 51303L, 65535L, false, false, 0L),
    CRC_16_DDS_110("CRC-16/DDS-110", 16, 32773L, 32781L, false, false, 0L),
    CRC_16_DECT_R("CRC-16/DECT-R", 16, 1417L, 0L, false, false, 1L),
    CRC_16_DECT_X("CRC-16/DECT-X", 16, 1417L, 0L, false, false, 0L),
    CRC_16_DNP("CRC-16/DNP", 16, 15717L, 0L, true, true, 65535L),
    CRC_16_EN_13757("CRC-16/EN-13757", 16, 15717L, 0L, false, false, 65535L),
    CRC_16_GENIBUS("CRC-16/GENIBUS", 16, 4129L, 65535L, false, false, 65535L),
    CRC_16_MAXIM("CRC-16/MAXIM", 16, 32773L, 0L, true, true, 65535L),
    CRC_16_MCRF4XX("CRC-16/MCRF4XX", 16, 4129L, 65535L, true, true, 0L),
    CRC_16_RIELLO("CRC-16/RIELLO", 16, 4129L, 45738L, true, true, 0L),
    CRC_16_T10_DIF("CRC-16/T10-DIF", 16, 35767L, 0L, false, false, 0L),
    CRC_16_TELEDISK("CRC-16/TELEDISK", 16, 41111L, 0L, false, false, 0L),
    CRC_16_TMS37157("CRC-16/TMS37157", 16, 4129L, 35308L, true, true, 0L),
    CRC_16_USB("CRC-16/USB", 16, 32773L, 65535L, true, true, 65535L),
    CRC_16_A("CRC-16/A", 16, 4129L, 50886L, true, true, 0L),
    CRC_16_KERMIT("CRC-16/KERMIT", 16, 4129L, 0L, true, true, 0L),
    CRC_16_MODBUS("CRC-16/MODBUS", 16, 32773L, 65535L, true, true, 0L),
    CRC_16_X25("CRC-16/X-25", 16, 4129L, 65535L, true, true, 65535L),
    CRC_16_XMODEM("CRC-16/XMODEM", 16, 4129L, 0L, false, false, 0L),
    CRC_32("CRC-32", 32, 79764919L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL),
    CRC_32_BZIP2("CRC-32/BZIP2", 32, 79764919L, 0xFFFFFFFFL, false, false, 0xFFFFFFFFL),
    CRC_32_C("CRC-32/C", 32, 517762881L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL),
    CRC_32_D("CRC-32/D", 32, 2821953579L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL),
    CRC_32_JAMCRC("CRC-32/JAMCRC", 32, 79764919L, 0xFFFFFFFFL, true, true, 0L),
    CRC_32_MPEG2("CRC-32/MPEG-2", 32, 79764919L, 0xFFFFFFFFL, false, false, 0L),
    CRC_32_POSIX("CRC-32/POSIX", 32, 79764919L, 0L, false, false, 0xFFFFFFFFL),
    CRC_32_Q("CRC-32/Q", 32, 2168537515L, 0L, false, false, 0L),
    CRC_32_XFER("CRC-32/XFER", 32, 175L, 0L, false, false, 0L),
    CRC_64("CRC-64", 64, 4823603603198064275L, 0L, false, false, 0L),
    CRC_64_WE("CRC-64/WE", 64, 4823603603198064275L, -1L, false, false, -1L),
    CRC_64_XZ("CRC-64/XZ", 64, 4823603603198064275L, -1L, true, true, -1L);

    private CrcAlgorithm _crcAlgorithm;

    private CrcStandard(String aName, int aCrcBitWidth, long aPolynomial, long aInitCrc, boolean aRefIn, boolean aRefOut, long aXorOut) {
        this._crcAlgorithm = new CrcAlgorithmImpl(aName, aCrcBitWidth, aPolynomial, aInitCrc, aRefIn, aRefOut, aXorOut);
    }

    @Override
    public long toCrcChecksum(byte aData) {
        return this._crcAlgorithm.toCrcChecksum(aData);
    }

    public String getName() {
        return this._crcAlgorithm.getName();
    }

    @Override
    public int getCrcWidth() {
        return this._crcAlgorithm.getCrcWidth();
    }

    @Override
    public long toCrcChecksum(long aCrc, byte aData) {
        return this._crcAlgorithm.toCrcChecksum(aCrc, aData);
    }

    @Override
    public long toCrcChecksum(byte[] aData) {
        return this._crcAlgorithm.toCrcChecksum(aData);
    }

    @Override
    public long toCrcChecksum(long aCrc, byte[] aData) {
        return this._crcAlgorithm.toCrcChecksum(aCrc, aData);
    }

    @Override
    public long toCrcChecksum(byte[] aData, int aOffset, int aLength) {
        return this._crcAlgorithm.toCrcChecksum(aData, aOffset, aLength);
    }

    @Override
    public long toCrcChecksum(long aCrc, byte[] aData, int aOffset, int aLength) {
        return this._crcAlgorithm.toCrcChecksum(aCrc, aData, aOffset, aLength);
    }

    @Override
    public byte[] toCrcBytes(byte aData, Endianess aEndianess) {
        return this._crcAlgorithm.toCrcBytes(aData, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(long aCrc, byte aData, Endianess aEndianess) {
        return this._crcAlgorithm.toCrcBytes(aCrc, aData, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(byte[] aData, Endianess aEndianess) {
        return this._crcAlgorithm.toCrcBytes(aData, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(long aCrc, byte[] aData, Endianess aEndianess) {
        return this._crcAlgorithm.toCrcBytes(aCrc, aData, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(byte[] aData, int aOffset, int aLength, Endianess aEndianess) {
        return this._crcAlgorithm.toCrcBytes(aData, aOffset, aLength, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(long aCrc, byte[] aData, int aOffset, int aLength, Endianess aEndianess) {
        return this._crcAlgorithm.toCrcBytes(aCrc, aData, aOffset, aLength, aEndianess);
    }

    @Override
    public CrcSize getCrcSize() {
        return this._crcAlgorithm.getCrcSize();
    }

    public String toString() {
        return this._crcAlgorithm.getName();
    }
}

