/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.util.ArrayList;
import org.refcodes.numerical.CrcStandard;
import org.refcodes.numerical.CrcWidthAccessor;

public enum CrcSize implements CrcWidthAccessor
{
    CRC_8(1),
    CRC_16(2),
    CRC_32(4),
    CRC_64(8);

    private int _crcByteWidth;
    private CrcStandard[] _crcAlgorithms;

    private CrcSize(int aCrcByteWidth) {
        ArrayList<CrcStandard> theCrcAlgorithms = new ArrayList<CrcStandard>();
        for (CrcStandard eCrcAlgorithm : CrcStandard.values()) {
            if (eCrcAlgorithm.getCrcWidth() != aCrcByteWidth) continue;
            theCrcAlgorithms.add(eCrcAlgorithm);
        }
        this._crcAlgorithms = theCrcAlgorithms.toArray(new CrcStandard[theCrcAlgorithms.size()]);
        this._crcByteWidth = aCrcByteWidth;
    }

    @Override
    public int getCrcWidth() {
        return this._crcByteWidth;
    }

    public CrcStandard[] getCrcAlgorithms() {
        return this._crcAlgorithms;
    }

    public static CrcSize toCrcCategory(int aCrcByteWidth) {
        for (CrcSize eCrcWidth : CrcSize.values()) {
            if (eCrcWidth.getCrcWidth() != aCrcByteWidth) continue;
            return eCrcWidth;
        }
        return null;
    }
}

