/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.data.CharSet;
import org.refcodes.mixin.CharSetAccessor;
import org.refcodes.numerical.NumberBaseAccessor;
import org.refcodes.numerical.NumericalUtility;

public class BaseConverterBuilder
implements CharSetAccessor.CharSetProperty,
CharSetAccessor.CharSetBuilder<BaseConverterBuilder>,
NumberBaseAccessor.NumberBaseProperty,
NumberBaseAccessor.NumberBaseBuilder<BaseConverterBuilder> {
    private static final int DECIMAL_NUMBER_BASE = 10;
    private int _numberBase = 10;
    private String _digits = null;
    private long _number;
    private char[] _charSet = null;

    public BaseConverterBuilder() {
        this.setCharSet(CharSet.ARABIC_BASE64.getCharSet());
    }

    public char[] getCharSet() {
        return this._charSet;
    }

    public void setCharSet(char[] cArray) {
        this._charSet = cArray;
    }

    public BaseConverterBuilder withCharSet(char[] cArray) {
        this.setCharSet(cArray);
        return this;
    }

    @Override
    public void setNumberBase(int n) {
        this._numberBase = n;
    }

    @Override
    public int getNumberBase() {
        return this._numberBase;
    }

    public String toDigits(long l) {
        return BaseConverterBuilder.asEncoded(l, this._numberBase, this._charSet);
    }

    public long getNumber() {
        return this._number;
    }

    public long toNumber(String string) throws IllegalArgumentException {
        return BaseConverterBuilder.asDecoded(string, this._numberBase, this._charSet);
    }

    public void setNumber(long l) {
        this._number = l;
    }

    public String getDigits() {
        this._digits = BaseConverterBuilder.asEncoded(this._number, this._numberBase, this._charSet);
        return this._digits;
    }

    public void setDigits(String string) {
        this._digits = string;
        this._number = BaseConverterBuilder.asDecoded(string, this._numberBase, this._charSet);
    }

    @Override
    public BaseConverterBuilder withNumberBase(int n) {
        this.setNumberBase(n);
        return this;
    }

    public BaseConverterBuilder withDigits(String string) {
        this.setDigits(string);
        return this;
    }

    public BaseConverterBuilder withNumber(long l) {
        this.setNumber(l);
        return this;
    }

    public static String asEncoded(long l, int n, char ... cArray) {
        return NumericalUtility.toNumberBase(l, n, cArray);
    }

    public static long asDecoded(String string, int n, char ... cArray) {
        return NumericalUtility.fromNumberBase(n, cArray, string);
    }
}

