/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.mixin.ReadTimeoutMillisAccessor;

public class TimeoutInputStream
extends InputStream
implements ReadTimeoutMillisAccessor {
    protected InputStream _inputStream;
    protected long _readTimeoutMillis;
    protected boolean _isClosed = false;
    private ExecutorService _executorService = null;

    public TimeoutInputStream(InputStream aInputStream, long aTimeoutMillis) {
        this(aInputStream, aTimeoutMillis, null);
    }

    public TimeoutInputStream(InputStream aInputStream, ExecutorService aExecutorService) {
        this(aInputStream, -1L, aExecutorService);
    }

    public TimeoutInputStream(InputStream aInputStream) {
        this(aInputStream, -1L, null);
    }

    public TimeoutInputStream(InputStream aInputStream, long aTimeoutMillis, ExecutorService aExecutorService) {
        this._inputStream = aInputStream;
        this._readTimeoutMillis = aTimeoutMillis;
        this._executorService = aExecutorService;
    }

    @Override
    public int read() throws IOException {
        return this.read(this._readTimeoutMillis);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len, this._readTimeoutMillis);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, this._readTimeoutMillis);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.readNBytes(b, off, len, this._readTimeoutMillis);
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.readNBytes(len, this._readTimeoutMillis);
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this._isClosed = true;
        this._inputStream.close();
        super.close();
    }

    @Override
    public void mark(int readlimit) {
        this._inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this._inputStream.reset();
    }

    public int read(long aTimeoutMillis) throws IOException {
        return this.timeout(this._inputStream::read, 1L, -1, aTimeoutMillis);
    }

    public int read(byte[] b, int off, int len, long aTimeoutMillis) throws IOException {
        return this.timeout(() -> this._inputStream.read(b, off, len), len, -1, aTimeoutMillis);
    }

    public int read(byte[] b, long aTimeoutMillis) throws IOException {
        return this.timeout(() -> this._inputStream.read(b), b.length, -1, aTimeoutMillis);
    }

    public int readNBytes(byte[] b, int off, int len, long aTimeoutMillis) throws IOException {
        return this.timeout(() -> this._inputStream.readNBytes(b, off, len), len, -1, aTimeoutMillis);
    }

    public byte[] readNBytes(int len, long aTimeoutMillis) throws IOException {
        return this.timeout(() -> this._inputStream.readNBytes(len), len, null, aTimeoutMillis);
    }

    public long skip(long n, long aTimeoutMillis) throws IOException {
        return this.timeout(() -> this._inputStream.skip(n), n, -1L, aTimeoutMillis);
    }

    public void skipNBytes(long n, long aTimeoutMillis) throws IOException {
        this.timeout(() -> this._inputStream.skipNBytes(n), n, aTimeoutMillis);
    }

    public long transferTo(OutputStream out, long aTimeoutMillis) throws IOException {
        return this.timeout(() -> this._inputStream.transferTo(out), this.available(), -1L, aTimeoutMillis);
    }

    public byte[] readAllBytes(long aTimeoutMillis) throws IOException {
        return this.timeout(this._inputStream::readAllBytes, this.available(), null, aTimeoutMillis);
    }

    public long getReadTimeoutMillis() {
        return this._readTimeoutMillis;
    }

    private <R> R timeout(Reader<R> aReader, long aLength, R aDefaultResult, long aTimeoutMillis) throws IOException {
        if (this._isClosed) {
            return aDefaultResult;
        }
        if (this._readTimeoutMillis == -1L || (long)this.available() >= aLength) {
            return aReader.read();
        }
        CompletableFuture<Object> theFuture = new CompletableFuture<Object>();
        theFuture.completeAsync(() -> {
            try {
                return aReader.read();
            }
            catch (Exception e) {
                theFuture.completeExceptionally(e);
                return aDefaultResult;
            }
        }, this._executorService != null ? this._executorService : theFuture.defaultExecutor());
        try {
            return (R)theFuture.get(aTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new TimeoutIOException(aTimeoutMillis, "Operation timed out after <" + aTimeoutMillis + "> milliseconds while trying to read <" + aLength + "> number of bytes.", (Throwable)e);
        }
    }

    private void timeout(Runner aRunner, long aLength, long aTimeoutMillis) throws IOException {
        if (this._isClosed) {
            return;
        }
        if (this._readTimeoutMillis == -1L || (long)this.available() >= aLength) {
            aRunner.run();
        } else {
            CompletableFuture<Void> theFuture = new CompletableFuture<Void>();
            theFuture.completeAsync(() -> {
                try {
                    aRunner.run();
                    return null;
                }
                catch (Exception e) {
                    theFuture.completeExceptionally(e);
                    return null;
                }
            }, this._executorService != null ? this._executorService : theFuture.defaultExecutor());
            try {
                theFuture.get(aTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new TimeoutIOException(aTimeoutMillis, "Operation timed out after <" + aTimeoutMillis + "> milliseconds while trying to read <" + aLength + "> number of bytes.", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    private static interface Reader<T> {
        public T read() throws IOException;
    }

    @FunctionalInterface
    private static interface Runner {
        public void run() throws IOException;
    }
}

